/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationException;
import com.atlassian.applinks.spi.auth.AuthenticationScenario;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.link.ReciprocalActionException;
import com.atlassian.applinks.spi.link.RemoteErrorListException;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.jira.ApplicationTypeNotInstalledException;
import com.atlassian.bitbucket.jira.IncorrectApplicationBaseUrlException;
import com.atlassian.bitbucket.jira.JiraSetupException;
import com.atlassian.bitbucket.jira.JiraSetupService;
import com.atlassian.bitbucket.jira.JiraUserCredentialsException;
import com.atlassian.bitbucket.jira.NotAJiraServerException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.stash.internal.jira.CrowdApplicationEntity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@AvailableToPlugins(value=JiraSetupService.class)
public class JiraSetupServiceImpl
implements JiraSetupService {
    private static final Logger log = LoggerFactory.getLogger(JiraSetupServiceImpl.class);
    private static final ImmutableSet<OperationType> ALLOWED_DIRECTORY_OPERATIONS = Sets.immutableEnumSet((Enum)OperationType.UPDATE_USER_ATTRIBUTE, (Enum[])new OperationType[]{OperationType.UPDATE_GROUP_ATTRIBUTE});
    private static final String CROWD_DIRECTORY_NAME = "Jira User Directory";
    private static final int POLLING_INTERVAL_SECONDS = 3600;
    private static final String JIRA_SYSADMIN_GROUP = "jira-administrators";
    private final MutatingApplicationLinkService applicationLinkService;
    private final TypeAccessor typeAccessor;
    private final ManifestRetriever manifestRetriever;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryManager directoryManager;
    private final ApplicationManager applicationManager;
    private final I18nService i18nService;
    private final PermissionAdminService permissionAdminService;
    private final HostApplication hostApplication;

    @Autowired
    public JiraSetupServiceImpl(MutatingApplicationLinkService applicationLinkService, TypeAccessor typeAccessor, HostApplication hostApplication, ManifestRetriever manifestRetriever, CrowdDirectoryService crowdDirectoryService, DirectoryManager directoryManager, PermissionAdminService permissionAdminService, ApplicationManager applicationManager, I18nService i18nService) {
        this.applicationLinkService = applicationLinkService;
        this.typeAccessor = typeAccessor;
        this.hostApplication = hostApplication;
        this.manifestRetriever = manifestRetriever;
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryManager = directoryManager;
        this.permissionAdminService = permissionAdminService;
        this.applicationManager = applicationManager;
        this.i18nService = i18nService;
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void createLink(URI remoteRpcUrl, URI localRpcUrl, String username, String password, boolean setupUserManagement) throws JiraSetupException {
        remoteRpcUrl = UrlUtils.trimTrailingSlashesFromPath((URI)remoteRpcUrl);
        localRpcUrl = UrlUtils.trimTrailingSlashesFromPath((URI)localRpcUrl);
        this.checkServerIsJiraWithEmbeddedCrowd(remoteRpcUrl);
        this.checkAdminCredentials(remoteRpcUrl, username, password);
        this.createLinkInRemoteApplication(remoteRpcUrl, localRpcUrl, username, password);
        ApplicationLink applicationLink = this.createApplicationLink(remoteRpcUrl);
        this.authenticateAndAuthorise(remoteRpcUrl, localRpcUrl, username, password, setupUserManagement, applicationLink);
    }

    @VisibleForTesting
    void checkServerIsJiraWithEmbeddedCrowd(URI remoteRpcUrl) {
        Manifest manifest;
        try {
            manifest = this.manifestRetriever.getManifest(remoteRpcUrl);
        }
        catch (ManifestNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to retrieve manifest from " + String.valueOf(remoteRpcUrl), (Throwable)e);
            }
            throw new NotAJiraServerException(this.i18nService.getMessage("bitbucket.web.jira.setup.notajiraserver", new Object[0]), (Throwable)e);
        }
        if (!manifest.getTypeId().equals((Object)TypeId.getTypeId((com.atlassian.applinks.api.ApplicationType)this.getJiraApplicationType()))) {
            throw new NotAJiraServerException(this.i18nService.getMessage("bitbucket.web.jira.setup.wrongappurl", new Object[]{StringUtils.capitalize((String)manifest.getTypeId().get())}));
        }
    }

    @VisibleForTesting
    void checkAdminCredentials(URI remoteRpcUrl, String username, String password) {
        try {
            if (!this.applicationLinkService.isAdminUserInRemoteApplication(remoteRpcUrl, username, password)) {
                throw new JiraUserCredentialsException(this.i18nService.getMessage("bitbucket.web.jira.setup.badcredentials", new Object[]{username}));
            }
        }
        catch (ResponseException e) {
            throw new JiraSetupException(this.i18nService.getMessage("bitbucket.web.jira.setup.credentialsexception", new Object[]{e}));
        }
    }

    private void authenticateAndAuthorise(URI remoteRpcUrl, URI localRpcUrl, String username, String password, boolean setupUserManagement, ApplicationLink applicationLink) {
        try {
            this.authenticateApplicationLink(applicationLink, username, password, localRpcUrl);
            if (setupUserManagement) {
                String hostname = remoteRpcUrl.getHost();
                CrowdApplicationEntity crowdApplication = this.createStashApplicationInCrowd(applicationLink, hostname, username, password);
                this.setupJiraDirectory(remoteRpcUrl, crowdApplication.getName(), crowdApplication.getPassword());
                this.grantPermissionsToStandardJiraGroups();
            }
        }
        catch (JiraSetupException e) {
            this.applicationLinkService.deleteApplicationLink(applicationLink);
            throw e;
        }
    }

    private ApplicationLink createApplicationLink(URI remoteRpcUrl) {
        try {
            ApplicationLinkDetails linkDetails = ApplicationLinkDetails.builder().rpcUrl(remoteRpcUrl).displayUrl(remoteRpcUrl).isPrimary(true).name(JiraSetupServiceImpl.generateLinkName(remoteRpcUrl)).build();
            return this.applicationLinkService.createApplicationLink((com.atlassian.applinks.api.ApplicationType)this.getJiraApplicationType(), linkDetails);
        }
        catch (ManifestNotFoundException e) {
            throw new JiraSetupException(this.i18nService.getMessage("bitbucket.web.jira.setup.failedtoretrievemanifestduringapplinkcreation", new Object[0]), (Throwable)e);
        }
    }

    private void createLinkInRemoteApplication(URI remoteRpcUrl, URI localRpcUrl, String username, String password) {
        try {
            this.applicationLinkService.createReciprocalLink(Objects.requireNonNull(remoteRpcUrl, "remoteRpcUrl"), Objects.requireNonNull(localRpcUrl, "localRpcUrl"), Objects.requireNonNull(username, "username"), Objects.requireNonNull(password, "password"));
        }
        catch (RemoteErrorListException e) {
            if (JiraSetupServiceImpl.remoteErrorMessageStartsWith(e, "There is no application type ")) {
                throw new ApplicationTypeNotInstalledException(this.i18nService.getMessage("bitbucket.web.jira.setup.remotestashapplicationtypemissing", new Object[]{Product.NAME}), (Throwable)e);
            }
            if (JiraSetupServiceImpl.remoteErrorMessageStartsWith(e, "Can't access application via URL")) {
                throw new IncorrectApplicationBaseUrlException(this.i18nService.getMessage("bitbucket.web.jira.setup.incorrectstashbaseurl", new Object[]{Product.NAME}), (Throwable)e);
            }
            this.throwDefaultRecriprocalActionFailedException(remoteRpcUrl, localRpcUrl, (ReciprocalActionException)((Object)e));
        }
        catch (ReciprocalActionException e) {
            this.throwDefaultRecriprocalActionFailedException(remoteRpcUrl, localRpcUrl, e);
        }
    }

    private JiraApplicationType getJiraApplicationType() {
        JiraApplicationType jiraType = (JiraApplicationType)this.typeAccessor.getApplicationType(JiraApplicationType.class);
        if (jiraType == null) {
            throw new JiraSetupException(this.i18nService.getMessage("bitbucket.web.jira.setup.localjiraapplicationtypemissing", new Object[]{JiraApplicationType.class}));
        }
        return jiraType;
    }

    protected static boolean remoteErrorMessageStartsWith(RemoteErrorListException e, String text) {
        for (String msg : e.getErrors()) {
            if (!msg.startsWith(text)) continue;
            return true;
        }
        return false;
    }

    private void throwDefaultRecriprocalActionFailedException(URI remoteRpcUrl, URI localRpcUrl, ReciprocalActionException e) {
        throw new JiraSetupException(this.i18nService.getMessage("bitbucket.web.jira.setup.genericreciprocalapplicationlinkfailure", new Object[]{remoteRpcUrl, localRpcUrl, Product.NAME}), (Throwable)e);
    }

    protected void authenticateApplicationLink(ApplicationLink applicationLink, String username, String password, URI localRpcUrl) {
        AuthenticationScenario authenticationScenario = new AuthenticationScenario(this){

            public boolean isCommonUserBase() {
                return false;
            }

            public boolean isTrusted() {
                return true;
            }
        };
        try {
            this.applicationLinkService.configureAuthenticationForApplicationLink(applicationLink, authenticationScenario, username, password);
        }
        catch (AuthenticationConfigurationException e) {
            throw new JiraSetupException(this.i18nService.getMessage("bitbucket.web.jira.setup.applink.authenticationconfigurationfailure", new Object[]{applicationLink.getRpcUrl(), localRpcUrl, Product.NAME}), (Throwable)e);
        }
    }

    private CrowdApplicationEntity createStashApplicationInCrowd(ApplicationLink applicationLink, String hostname, String username, String password) {
        ApplicationLinkRequest request;
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(Anonymous.class);
        try {
            request = requestFactory.createRequest(Request.MethodType.POST, "rest/appmanagement/1/application?include-request-address=true");
        }
        catch (CredentialsRequiredException e) {
            throw new IllegalStateException("Anonymous authentication provider should never throw CredentialsRequiredException", e);
        }
        request.addBasicAuthentication(hostname, username, password);
        CrowdApplicationEntity applicationEntity = this.createApplicationEntity();
        request.setEntity((Object)applicationEntity);
        CrowdResult crowdResult = this.executeRequest(request);
        if (!crowdResult.isOk()) {
            throw new JiraSetupException(crowdResult.message, (Throwable)crowdResult.exception);
        }
        return applicationEntity;
    }

    private CrowdApplicationEntity createApplicationEntity() {
        ApplicationType type = ApplicationType.GENERIC_APPLICATION;
        String appname = this.generateName(type);
        String password = DefaultSecureTokenGenerator.getInstance().generateToken();
        String description = "Automatically created by the setup of " + type.getDisplayName() + " on " + SimpleDateFormat.getDateInstance().format(new Date());
        return new CrowdApplicationEntity(type, appname, password, description, true);
    }

    private String generateName(ApplicationType type) {
        ApplicationId id = this.hostApplication.getId();
        URI url = this.hostApplication.getBaseUrl();
        return type.getDisplayName() + " - " + StringUtils.defaultString((String)url.getHost()) + " - " + String.valueOf(id);
    }

    private CrowdResult executeRequest(ApplicationLinkRequest request) {
        try {
            return (CrowdResult)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<CrowdResult>(){

                public CrowdResult credentialsRequired(Response response) {
                    throw new IllegalStateException("Anonymous authentication provider should never invoke ApplicationLinkResponseHandler#credentialsRequired()");
                }

                public CrowdResult handle(Response response) throws ResponseException {
                    if (!response.isSuccessful()) {
                        return new CrowdResult(CrowdResultType.NOT_20x, JiraSetupServiceImpl.this.i18nService.getMessage("bitbucket.web.jira.setup.failedtoregisterstashcrowdconfiguration", new Object[]{Product.NAME, response.getStatusCode(), response.getStatusText()}), null);
                    }
                    return new CrowdResult(CrowdResultType.OK, null, null);
                }
            });
        }
        catch (ResponseException e) {
            return new CrowdResult(CrowdResultType.BAD_RESPONSE, this.i18nService.getMessage("bitbucket.web.jira.setup.failedtoregisterstashcrowdconfiguration.exception", new Object[]{e, Product.NAME}), (Exception)((Object)e));
        }
    }

    private void setupJiraDirectory(URI crowdServerUrl, String applicationName, String applicationPassword) {
        if (this.directoryNameInUse(CROWD_DIRECTORY_NAME)) {
            throw new JiraSetupException(this.i18nService.getMessage("bitbucket.web.jira.setup.crowddirectorynamealreadyexists", new Object[]{CROWD_DIRECTORY_NAME}));
        }
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        Date now = new Date();
        builder.setCreatedDate(now);
        builder.setUpdatedDate(now);
        builder.setAllowedOperations(ALLOWED_DIRECTORY_OPERATIONS);
        builder.setActive(true);
        builder.setImplementationClass(RemoteCrowdDirectory.class.getName());
        builder.setName(CROWD_DIRECTORY_NAME);
        builder.setType(DirectoryType.CROWD);
        HashMap attributes = Maps.newHashMap();
        attributes.put("application.name", applicationName);
        attributes.put("application.password", applicationPassword);
        attributes.put("crowd.server.url", crowdServerUrl.toASCIIString());
        attributes.put("useNestedGroups", "false");
        attributes.put("directory.cache.synchronise.interval", Long.toString(3600L));
        attributes.put("crowd.sync.incremental.enabled", "true");
        builder.setAttributes((Map)attributes);
        Directory directory = this.crowdDirectoryService.addDirectory(builder.toDirectory());
        log.info("Jira user directory created: [ {} ], type: [ {} ]", (Object)directory.getName(), (Object)directory.getType());
        try {
            Application stashApplication = this.applicationManager.findByName("crowd-embedded");
            OperationType[] operationTypes = (OperationType[])ALLOWED_DIRECTORY_OPERATIONS.toArray((Object[])new OperationType[ALLOWED_DIRECTORY_OPERATIONS.size()]);
            this.applicationManager.addDirectoryMapping(stashApplication, directory, true, operationTypes);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException("Couldn't find mapping for crowd-embedded", e);
        }
        catch (DirectoryNotFoundException e) {
            throw new IllegalStateException("Couldn't find newly created directory Jira User Directory", e);
        }
    }

    private boolean directoryNameInUse(String directoryName) {
        return !this.getDirectoriesWithName(directoryName).isEmpty();
    }

    private List<Directory> getDirectoriesWithName(String directoryName) {
        EntityQuery directoryQuery = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.NAME).exactlyMatching((Object)directoryName)).returningAtMost(-1);
        return this.directoryManager.searchDirectories(directoryQuery);
    }

    private void grantPermissionsToStandardJiraGroups() {
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().globalPermission(Permission.SYS_ADMIN).group(JIRA_SYSADMIN_GROUP).build());
    }

    protected static String generateLinkName(URI remoteRpcUrl) {
        Object name = "Jira";
        if (remoteRpcUrl.getHost() != null) {
            name = remoteRpcUrl.getHost() + " " + (String)name;
        }
        return name;
    }

    private static class CrowdResult {
        final CrowdResultType type;
        final String message;
        final Exception exception;

        private CrowdResult(CrowdResultType type, String message, Exception exception) {
            this.type = type;
            this.message = message;
            this.exception = exception;
        }

        boolean isOk() {
            return this.type == CrowdResultType.OK;
        }
    }

    private static enum CrowdResultType {
        NOT_20x,
        BAD_RESPONSE,
        OK;

    }
}

