/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.job;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobCreationRequest;
import com.atlassian.bitbucket.job.JobMessage;
import com.atlassian.bitbucket.job.JobMessageCreationRequest;
import com.atlassian.bitbucket.job.JobMessageSearchRequest;
import com.atlassian.bitbucket.job.JobSearchRequest;
import com.atlassian.bitbucket.job.JobService;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.job.JobUpdateRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.job.InternalJob;
import com.atlassian.stash.internal.job.InternalJobMessage;
import com.atlassian.stash.internal.job.JobDao;
import com.atlassian.stash.internal.job.JobMessageDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@PreAuthorize(value="hasGlobalPermission('ADMIN')")
@AvailableToPlugins(interfaces={JobService.class})
@Service(value="jobService")
public class DefaultJobService
extends AbstractService
implements JobService {
    private final ClusterService clusterService;
    private final JobDao dao;
    private final JobMessageDao messageDao;

    @Autowired
    public DefaultJobService(ClusterService clusterService, JobDao dao, JobMessageDao messageDao) {
        this.clusterService = Objects.requireNonNull(clusterService, "clusterService");
        this.dao = Objects.requireNonNull(dao, "dao");
        this.messageDao = Objects.requireNonNull(messageDao, "messageDao");
    }

    public long countMessages(@Nonnull JobMessageSearchRequest request) {
        return this.messageDao.count(Objects.requireNonNull(request, "request"));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Nonnull
    public Job create(@Nonnull JobCreationRequest request) {
        Objects.requireNonNull(request, "request");
        Instant now = Instant.now();
        return (Job)this.dao.create((Object)new InternalJob.Builder().endDate(request.getState().isTerminated() ? now : null).initiator((InternalApplicationUser)request.getInitiator().map(InternalConverter::convertToInternalUser).orElse(null)).nodeId(this.clusterService.getNodeId()).progressMessage((String)request.getProgressMessage().orElse(null)).progressPercentage(request.getProgressPercentage()).state(request.getState()).type(request.getType()).build());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Nonnull
    public JobMessage createMessage(@Nonnull JobMessageCreationRequest request) {
        Objects.requireNonNull(request, "request");
        return (JobMessage)this.messageDao.create((Object)new InternalJobMessage.Builder().job(InternalConverter.convertToInternalJob((Job)request.getJob())).severity(request.getSeverity()).subject((String)request.getSubject().orElse(null)).text(request.getText()).build());
    }

    @Nonnull
    public Page<Job> search(@Nonnull JobSearchRequest request, @Nonnull PageRequest pageRequest) {
        return PageUtils.asPageOf(Job.class, (Page)this.dao.search(Objects.requireNonNull(request, "request"), Objects.requireNonNull(pageRequest, "pageRequest")));
    }

    @Nonnull
    public Page<JobMessage> searchMessages(@Nonnull JobMessageSearchRequest request, @Nonnull PageRequest pageRequest) {
        return PageUtils.asPageOf(JobMessage.class, (Page)this.messageDao.search(Objects.requireNonNull(request, "request"), Objects.requireNonNull(pageRequest, "pageRequest")));
    }

    @Nonnull
    public Optional<Job> getById(long jobId) {
        return Optional.ofNullable((Job)this.dao.getById((Object)jobId));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Nonnull
    public Job update(@Nonnull JobUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalJob job = InternalConverter.convertToInternalJob((Job)request.getJob());
        JobState oldState = job.getState();
        InternalJob.Builder builder = new InternalJob.Builder(job);
        Instant now = Instant.now();
        request.getState().filter(newState -> newState != oldState).ifPresent(newState -> {
            builder.state(newState);
            if (newState.isTerminated() && !job.getEndDate().isPresent()) {
                builder.endDate(now);
            }
        });
        request.getProgressPercentage().ifPresent(arg_0 -> ((InternalJob.Builder)builder).progressPercentage(arg_0));
        request.getProgressMessage().ifPresent(arg_0 -> ((InternalJob.Builder)builder).progressMessage(arg_0));
        return (Job)this.dao.update((Object)builder.build());
    }
}

