/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.json;

import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.plugin.JsonRendererModuleDescriptor;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=JsonRenderer.class)
@Component(value="jsonRenderer")
public class PluginJsonRenderer
implements JsonRenderer {
    private static final Logger log = LoggerFactory.getLogger(JsonRenderer.class);
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginJsonRenderer(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public String render(Object object, @Nonnull Map<String, Object> options) {
        if (object == null) {
            return null;
        }
        Collection sortedModules = ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(JsonRendererModuleDescriptor.class)).collect(Collectors.toList());
        for (JsonRenderer renderer : sortedModules) {
            try {
                String result = renderer.render(object, options);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                log.warn("Failed to marshal " + object.getClass().getName() + " to JSON", (Throwable)e);
            }
        }
        log.debug("No json-renderer was found that knew how to render {}", (Object)object.getClass().getName());
        return null;
    }
}

