/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.language;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.language.Language;
import com.atlassian.stash.internal.plugin.LanguageModuleDescriptor;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="languageService")
public class PluginLanguageService
implements InternalLanguageService {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginLanguageService(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public SortedSet<Language> getLanguages() {
        TreeSet<Language> languages = new TreeSet<Language>();
        for (LanguageModuleDescriptor descriptor : this.pluginAccessor.getEnabledModuleDescriptorsByClass(LanguageModuleDescriptor.class)) {
            languages.add(new Language(descriptor.getModule()));
        }
        return Collections.unmodifiableSortedSet(languages);
    }
}

