/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.license.GracePeriodHandler;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="gracePeriodHandler")
public class DefaultGracePeriodHandler
implements GracePeriodHandler {
    static final long GRACE_PERIOD = TimeUnit.HOURS.toMillis(24L);
    static final long ONE_HOUR = TimeUnit.HOURS.toMillis(1L);
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final Clock clock;
    private final I18nService i18nService;

    @Autowired
    public DefaultGracePeriodHandler(InternalApplicationPropertiesService applicationPropertiesService, Clock clock, I18nService i18nService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.clock = clock;
        this.i18nService = i18nService;
    }

    @Override
    public boolean isActive() {
        return this.getPositiveRemainingGracePeriod().isPresent();
    }

    @Override
    @Nonnull
    public Optional<KeyedMessage> getMessage() {
        return this.getPositiveRemainingGracePeriod().map(this::getGracePeriodMessage);
    }

    @Override
    @Nonnull
    public Optional<Long> getStartTime() {
        return this.applicationPropertiesService.getGracePeriodStartTime();
    }

    @Override
    public void start() {
        if (!this.getStartTime().isPresent()) {
            this.updateGracePeriodStartTime(this.clock.utcMillis());
        }
    }

    @Override
    public void stop() {
        if (this.getRemainingGracePeriod().isPresent()) {
            this.resetGracePeriodStartTime();
        }
    }

    private KeyedMessage getGracePeriodMessage(long remainingGracePeriod) {
        if (remainingGracePeriod < ONE_HOUR) {
            return this.i18nService.createKeyedMessage("bitbucket.license.over.limit.grace.period.minutes", new Object[]{TimeUnit.MILLISECONDS.toMinutes(remainingGracePeriod)});
        }
        return this.i18nService.createKeyedMessage("bitbucket.license.over.limit.grace.period.hours", new Object[]{TimeUnit.MILLISECONDS.toHours(remainingGracePeriod)});
    }

    private Optional<Long> getPositiveRemainingGracePeriod() {
        return this.getRemainingGracePeriod().filter(remainingGracePeriod -> remainingGracePeriod > 0L);
    }

    private Optional<Long> getRemainingGracePeriod() {
        return this.getStartTime().map(startTime -> GRACE_PERIOD - (this.clock.utcMillis() - startTime));
    }

    private void resetGracePeriodStartTime() {
        this.applicationPropertiesService.setGracePeriodStartTime(null);
    }

    private void updateGracePeriodStartTime(long time) {
        this.applicationPropertiesService.setGracePeriodStartTime(Long.valueOf(time));
    }
}

