/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.stash.internal.license.DualLicense;
import com.atlassian.stash.internal.license.LicenseCache;
import com.atlassian.stash.internal.license.LicenseHelper;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="licenseCache")
public class DefaultLicenseCache
implements LicenseCache {
    private final CachedReference<Optional<DualLicense>> licenseReference;
    private final LicenseHelper licenseHelper;

    @Autowired
    public DefaultLicenseCache(CacheFactory cacheFactory, LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
        this.licenseReference = cacheFactory.getCachedReference(LicenseService.class, "BitbucketServerLicense", this::loadLicense, new CacheSettingsBuilder().remote().build());
    }

    @Override
    @Nonnull
    public Optional<DualLicense> get() {
        return (Optional)this.licenseReference.get();
    }

    @Override
    @Nonnull
    public Optional<String> getAsString() {
        return this.get().map(DualLicense::getEncodedLicense);
    }

    @Override
    public void reset() {
        this.licenseReference.reset();
    }

    @Nonnull
    private Optional<DualLicense> loadLicense() {
        return Optional.ofNullable(this.licenseHelper.getDecoded());
    }
}

