/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.bitbucket.event.license.LicenseChangedEvent;
import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.extras.core.AtlassianLicenseFactory;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.extras.decoder.api.LicenseVerificationException;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.license.SimpleDualLicense;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="licenseHelper")
public class DefaultLicenseHelper
implements LicenseHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultLicenseHelper.class);
    private final AtlassianLicenseFactory atlassianLicenseFactory;
    private final LicenseDecoder licenseDecoder;
    private final LicenseManager licenseManager;
    private final ApplicationPropertyDao propertyDao;
    private final EventPublisher eventPublisher;
    private final String setupLicense;

    @Autowired
    public DefaultLicenseHelper(AtlassianLicenseFactory atlassianLicenseFactory, LicenseDecoder licenseDecoder, LicenseManager licenseManager, ApplicationPropertyDao propertyDao, EventPublisher eventPublisher, @Value(value="${setup.license:}") String setupLicense) {
        this.atlassianLicenseFactory = atlassianLicenseFactory;
        this.licenseDecoder = licenseDecoder;
        this.licenseManager = licenseManager;
        this.propertyDao = propertyDao;
        this.eventPublisher = eventPublisher;
        this.setupLicense = this.getSetupLicense(setupLicense);
    }

    public SimpleDualLicense decode(@Nonnull String license) {
        if (this.licenseDecoder.canDecode(license)) {
            try {
                AtlassianLicense decoded = this.licenseManager.getLicense(license);
                return this.getSimpleDualLicense(license, decoded, false);
            }
            catch (LicenseVerificationException e) {
                if (DevModeUtils.isEnabled()) {
                    log.warn("The provided license could not be verified; {}", (Object)e.getMessage());
                } else {
                    log.warn("The provided license could not be verified", (Throwable)e);
                }
                Properties licenseProperties = e.getLicenseProperties();
                if (licenseProperties == null || licenseProperties.isEmpty()) {
                    log.warn("The provided license did not have any valid properties");
                }
                AtlassianLicense decoded = this.atlassianLicenseFactory.getLicense(licenseProperties);
                return this.getSimpleDualLicense(license, decoded, true);
            }
            catch (Exception e) {
                log.warn("The provided license could not be decoded", (Throwable)e);
            }
        }
        throw new IllegalArgumentException();
    }

    public String get() {
        String storedLicense = this.getStoredLicense();
        return storedLicense == null && !this.propertyDao.isSetup() ? this.setupLicense : storedLicense;
    }

    public SimpleDualLicense getDecoded() {
        String encodedLicense = this.get();
        return encodedLicense == null ? null : this.decode(encodedLicense);
    }

    public void set(@Nonnull String newLicense) {
        String previousLicense = this.getStoredLicense();
        if (previousLicense == null) {
            this.propertyDao.create(new ApplicationProperty(ApplicationProperty.Key.LICENSE, newLicense));
        } else if (!previousLicense.equals(newLicense)) {
            this.propertyDao.update(new ApplicationProperty(ApplicationProperty.Key.LICENSE, newLicense));
        } else {
            return;
        }
        this.eventPublisher.publish((Object)new LicenseChangedEvent((Object)this, (BitbucketServerLicense)this.decode(newLicense), previousLicense == null ? null : this.decode(previousLicense)));
    }

    private SimpleDualLicense getSimpleDualLicense(String license, AtlassianLicense decoded, boolean forged) {
        ProductLicense productLicense = decoded.getProductLicense(Product.BITBUCKET_SERVER);
        if (productLicense instanceof BitbucketServerLicense) {
            return new SimpleDualLicense((BitbucketServerLicense)productLicense, license, forged);
        }
        log.warn("The decoded license does not include a Bitbucket license. Products licensed: {}", (Object)Iterables.toString((Iterable)decoded.getProductLicenses()));
        return null;
    }

    private String getStoredLicense() {
        ApplicationProperty property = this.propertyDao.getById(ApplicationProperty.Key.LICENSE);
        return property == null ? null : property.getValue();
    }

    private String getSetupLicense(String setupLicense) {
        SimpleDualLicense dualLicense = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)setupLicense)) {
                dualLicense = this.decode(setupLicense);
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Ignoring supplied license as it is invalid", (Throwable)e);
        }
        return dualLicense == null ? null : setupLicense;
    }
}

