/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.stash.internal.license.DualLicense;
import com.atlassian.stash.internal.license.GracePeriodHandler;
import com.atlassian.stash.internal.license.LicenseCache;
import com.atlassian.stash.internal.license.LicenseLimitHandler;
import com.atlassian.stash.internal.license.LicensedUserCache;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="licenseLimitHandler")
public class DefaultLicenseLimitHandler
implements LicenseLimitHandler {
    private final GracePeriodHandler gracePeriodHandler;
    private final I18nService i18nService;
    private final LicenseCache licenseCache;
    private final LicensedUserCache licensedUserCache;

    @Autowired
    public DefaultLicenseLimitHandler(GracePeriodHandler gracePeriodHandler, I18nService i18nService, LicenseCache licenseCache, LicensedUserCache licensedUserCache) {
        this.gracePeriodHandler = gracePeriodHandler;
        this.i18nService = i18nService;
        this.licenseCache = licenseCache;
        this.licensedUserCache = licensedUserCache;
    }

    @Override
    public boolean isWithinLimits() {
        return this.getLicense().filter(license -> !this.isOverLimit((DualLicense)license) || this.gracePeriodHandler.isActive()).isPresent();
    }

    @Override
    @Nonnull
    public Optional<KeyedMessage> getMessage() {
        if (this.getLicenseIfOverLimit().isPresent()) {
            return Optional.of(this.gracePeriodHandler.getMessage().orElse(this.i18nService.createKeyedMessage("bitbucket.license.over.limit", new Object[0])));
        }
        return Optional.empty();
    }

    private Optional<DualLicense> getLicense() {
        return this.licenseCache.get();
    }

    private Optional<DualLicense> getLicenseIfOverLimit() {
        return this.getLicense().filter(this::isOverLimit);
    }

    private boolean isOverLimit(DualLicense license) {
        if (license.isUnlimitedNumberOfUsers() || this.licensedUserCache.getCount() <= license.getMaximumNumberOfUsers()) {
            this.gracePeriodHandler.stop();
            return false;
        }
        this.gracePeriodHandler.start();
        return true;
    }
}

