/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionRevokedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.license.LicensedUserCache;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="licensedUserCache")
@DefaultApplicationMode
public class DefaultLicensedUserCache
implements LicensedUserCache,
ScheduledJobSource {
    private static final Duration EVENTUAL_CONSISTENCY_DELAY = Duration.of(60L, ChronoUnit.SECONDS);
    private static final JobId JOB_ID = JobId.of((String)DefaultLicensedUserCache.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)DefaultLicensedUserCache.class.getName());
    private static final Logger log = LoggerFactory.getLogger(DefaultLicensedUserCache.class);
    private static final Duration MAX_TOPIC_MESSAGE_LIFETIME = Duration.of(30L, ChronoUnit.SECONDS);
    private static final String NOTIFICATION_LICENSED_USER_COUNT = "LicensedUserCountCache";
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final Topic<Integer> cacheTopic;
    private final CachedReference<Set<String>> cachedUsernames;
    private final CrowdControl crowdControl;
    private final SynchronisationStatusManager crowdSyncStatusManager;
    private final InternalPermissionService permissionService;
    private final AtomicBoolean repopulateCacheAfterCrowdSync;
    private final SchedulerService schedulerService;
    private volatile Integer cachedValue;
    private volatile long lastTopicMessageReceived;
    private String subscriptionId;

    @Autowired
    public DefaultLicensedUserCache(InternalApplicationPropertiesService applicationPropertiesService, CacheFactory cacheFactory, CrowdControl crowdControl, SynchronisationStatusManager crowdSyncStatusManager, @Value(value="${license.cache.usernames.ttl}") int licensedUserCacheTtl, @Lazy InternalPermissionService permissionService, SchedulerService schedulerService, TopicService topicService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.crowdControl = crowdControl;
        this.crowdSyncStatusManager = crowdSyncStatusManager;
        this.permissionService = permissionService;
        this.repopulateCacheAfterCrowdSync = new AtomicBoolean();
        this.schedulerService = schedulerService;
        this.cacheTopic = topicService.getTopic(NOTIFICATION_LICENSED_USER_COUNT, new TopicSettings.Builder(Integer.class).dedupePendingMessages(true).build());
        this.cachedUsernames = cacheFactory.getCachedReference(LicensedUserCache.class.getName(), this::loadLicensedUsernames, new CacheSettingsBuilder().expireAfterWrite((long)licensedUserCacheTtl, TimeUnit.SECONDS).local().build());
    }

    @PostConstruct
    public void onCreate() {
        this.subscriptionId = this.cacheTopic.subscribe(message -> {
            long now = System.currentTimeMillis();
            if (!message.getSource().isLocal()) {
                this.cachedValue = (Integer)message.getMessage();
                this.cachedUsernames.reset();
                if (now - this.lastTopicMessageReceived < MAX_TOPIC_MESSAGE_LIFETIME.toMillis()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Received cache update {} from cluster node {} {} ms since the last recalculation, recalculating in {} ms", new Object[]{message.getMessage(), message.getSource().getAddress().getHostString(), now - this.lastTopicMessageReceived, EVENTUAL_CONSISTENCY_DELAY.toMillis()});
                    }
                    this.scheduleCacheRepopulation(EVENTUAL_CONSISTENCY_DELAY.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            this.lastTopicMessageReceived = now;
        });
        this.applicationPropertiesService.getLastLicensedUserCount().ifPresent(val -> {
            this.cachedValue = val;
        });
    }

    @PreDestroy
    public void onDestroy() {
        if (this.subscriptionId != null) {
            this.cacheTopic.unsubscribe(this.subscriptionId);
            this.subscriptionId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() {
        Integer count = this.getCachedCount();
        if (count == null) {
            DefaultLicensedUserCache defaultLicensedUserCache = this;
            synchronized (defaultLicensedUserCache) {
                count = this.getCachedCount();
                if (count == null) {
                    count = this.repopulateCacheNow();
                }
            }
        }
        return count;
    }

    @Override
    @Nonnull
    public Set<String> getUsernames() {
        return (Set)this.cachedUsernames.get();
    }

    @EventListener
    public void onClusterNodeAddedEvent(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.repopulateCacheLater();
        }
    }

    @EventListener
    public void onDirectorySynchronisedEvent(RemoteDirectorySynchronisedEvent event) {
        if (this.repopulateCacheAfterCrowdSync.compareAndSet(true, false)) {
            log.debug("Directory (id={}) synchronization complete. repopulating license cache.", (Object)event.getRemoteDirectory().getDirectoryId());
            this.repopulateCacheLater();
        }
    }

    @EventListener
    public void onPermissionGrantedEvent(GlobalPermissionGrantedEvent event) {
        if (log.isDebugEnabled()) {
            ApplicationUser affectedUser = event.getAffectedUser();
            if (affectedUser == null) {
                log.debug("{} granted to group {}. repopulating license cache.", (Object)event.getPermission(), (Object)event.getAffectedGroup());
            } else {
                log.debug("{} granted to user {}. repopulating license cache.", (Object)event.getPermission(), (Object)affectedUser.getName());
            }
        }
        this.repopulateCacheLater();
    }

    @EventListener
    public void onPermissionRevokedEvent(GlobalPermissionRevokedEvent event) {
        if (log.isDebugEnabled()) {
            ApplicationUser affectedUser = event.getAffectedUser();
            if (affectedUser == null) {
                log.debug("{} revoked from group {}. repopulating license cache.", (Object)event.getPermission(), (Object)event.getAffectedGroup());
            } else {
                log.debug("{} revoked from user {}. repopulating license cache.", (Object)event.getPermission(), (Object)affectedUser.getName());
            }
        }
        this.repopulateCacheLater();
    }

    @EventListener
    public void onDirectoryUpdated(DirectoryUpdatedEvent event) {
        log.debug("Directory (id={}) was updated. repopulating license cache.", (Object)event.getDirectory().getId());
        this.repopulateCacheLater();
    }

    @EventListener
    public void onGroupDeletedEvent(GroupDeletedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            this.repopulateCacheIfLicensedGroup(event.getGroupName());
        }
    }

    @EventListener
    public void onGroupMembershipsCreatedEvent(GroupMembershipsCreatedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            this.repopulateCacheIfLicensedGroup(event.getGroupName());
        }
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            this.repopulateCacheIfLicensedGroup(event.getGroupName());
        }
    }

    @EventListener
    public void onUserAutoUpdatedEvent(AutoUserUpdatedEvent event) {
        if (event.getUser().isActive() != event.getOriginalUser().isActive()) {
            this.onUserUpdatedEvent((UserUpdatedEvent)event);
        }
    }

    @EventListener
    public void onUserDeletedEvent(UserDeletedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            log.debug("User (name={}) was deleted. repopulating license cache.", (Object)event.getUsername());
            this.repopulateCacheLater();
        }
    }

    @EventListener
    public void onUserEditedEvent(UserEditedEvent event) {
        if (event.getUser().isActive() != event.getOriginalUser().isActive()) {
            this.onUserUpdatedEvent((UserUpdatedEvent)event);
        }
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent event) {
        this.onUserUpdatedEvent((UserUpdatedEvent)event);
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new RepopulateLicensedUserCacheJob());
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @Nonnull
    private Set<String> loadLicensedUsernames() {
        try (Ticker ignored = Timers.start((String)"DefaultLicensedUserCache: repopulating licensed usernames cache");){
            Set set = this.permissionService.getUsersWithPermission(Permission.LICENSED_USER);
            return set;
        }
    }

    private void onUserUpdatedEvent(UserUpdatedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            log.debug("User (name={}) was updated. repopulating license cache.", (Object)event.getUser().getName());
            this.repopulateCacheLater();
        }
    }

    private void repopulateCacheIfLicensedGroup(String groupName) {
        if (this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, groupName)) {
            this.repopulateCacheLater();
        } else {
            PageRequest request = PageUtils.newRequest((int)0, (int)10);
            Page licensedGroups = this.permissionService.getGrantedGroups(Permission.LICENSED_USER, request);
            if (!licensedGroups.getIsLastPage()) {
                this.repopulateCacheLater();
            } else {
                for (String licensedGroup : licensedGroups.getValues()) {
                    if (!this.crowdControl.isGroupMemberOfGroup(groupName, licensedGroup)) continue;
                    this.repopulateCacheLater();
                    break;
                }
            }
        }
    }

    private void putCachedCount(int count) {
        this.cachedValue = count;
        this.applicationPropertiesService.setLastLicensedUserCount(count);
        this.cacheTopic.publish((Serializable)Integer.valueOf(count));
    }

    private Integer getCachedCount() {
        return this.cachedValue;
    }

    private void repopulateCacheLater() {
        this.scheduleCacheRepopulation(0L, TimeUnit.SECONDS);
    }

    private int repopulateCacheNow() {
        this.cachedUsernames.reset();
        int count = ((Set)this.cachedUsernames.get()).size();
        this.putCachedCount(count);
        return count;
    }

    private void scheduleCacheRepopulation(long delay, TimeUnit unit) {
        Date nextCacheRepopulation = new Date(new Date().getTime() + TimeUnit.MILLISECONDS.convert(delay, unit));
        try {
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)nextCacheRepopulation)));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule licensed user count cache repopulation job", (Throwable)e);
        }
    }

    private boolean shouldRepopulateCache(DirectoryEvent event) {
        try {
            if (this.crowdSyncStatusManager.getDirectorySynchronisationInformation(event.getDirectoryId().longValue()).isSynchronising()) {
                log.debug("Directory (id={}) synchronization is in progress. Delaying repopulating license cache.", (Object)event.getDirectoryId());
                this.repopulateCacheAfterCrowdSync.set(true);
                return false;
            }
        }
        catch (DirectoryNotFoundException e) {
            log.warn("Directory (id={}) not found. Delaying repopulating license cache.", (Object)event.getDirectoryId());
            return false;
        }
        return true;
    }

    private class RepopulateLicensedUserCacheJob
    implements JobRunner {
        private RepopulateLicensedUserCacheJob() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            try {
                DefaultLicensedUserCache.this.repopulateCacheNow();
                return JobRunnerResponse.success();
            }
            catch (Exception e) {
                log.info("An error occurred when repopulating the licensed user count cache.", (Throwable)e);
                DefaultLicensedUserCache.this.scheduleCacheRepopulation(10L, TimeUnit.SECONDS);
                return JobRunnerResponse.failed((Throwable)e);
            }
        }
    }
}

