/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.license.InvalidLicenseException;
import com.atlassian.bitbucket.license.LicenseLimitException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.license.NotDataCenterLicenseException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.license.DualLicense;
import com.atlassian.stash.internal.license.InternalLicenseService;
import com.atlassian.stash.internal.license.LicenseCache;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.license.LicenseLimitHandler;
import com.atlassian.stash.internal.license.LicensedUserCache;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import jakarta.annotation.Nonnull;
import java.security.Principal;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=LicenseService.class)
@Service(value="licenseService")
@Transactional(propagation=Propagation.SUPPORTS)
public class LicenseServiceImpl
implements InternalLicenseService {
    private final I18nService i18nService;
    private final LicenseCache licenseCache;
    private final LicenseHelper licenseHelper;
    private final LicenseLimitHandler licenseLimitHandler;
    private final LicensedUserCache licensedUserCache;
    private final InternalPermissionService permissionService;
    private final ApplicationPropertiesService propertiesService;
    private final UserService userService;

    @Autowired
    public LicenseServiceImpl(I18nService i18nService, LicenseCache licenseCache, LicenseHelper licenseHelper, LicenseLimitHandler licenseLimitHandler, LicensedUserCache licensedUserCache, @Lazy InternalPermissionService permissionService, ApplicationPropertiesService propertiesService, UserService userService) {
        this.i18nService = i18nService;
        this.licenseCache = licenseCache;
        this.licenseLimitHandler = licenseLimitHandler;
        this.licenseHelper = licenseHelper;
        this.licensedUserCache = licensedUserCache;
        this.permissionService = permissionService;
        this.propertiesService = propertiesService;
        this.userService = userService;
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean isLicenseForged() {
        return this.licenseCache.get().map(DualLicense::isForged).orElse(Boolean.FALSE);
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean isLicenseValid() {
        return this.getValidityMessage() == null && this.licenseLimitHandler.isWithinLimits();
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean isPresent() {
        return this.get() != null;
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean isTestingLicense() {
        return this.licenseCache.get().filter(license -> LicenseType.TESTING == license.getLicenseType()).isPresent();
    }

    @Unsecured(value="everyone needs access to this method")
    public BitbucketServerLicense get() {
        return this.licenseCache.get().orElse(null);
    }

    @Unsecured(value="Access to the encrypted license is required by UPM")
    public String getAsString() {
        return this.licenseCache.getAsString().orElse(null);
    }

    @Unsecured(value="everyone needs access to this method")
    public int getLicensedUsersCount() {
        return this.licensedUserCache.getCount();
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean canLogin(Principal principal) {
        if (principal instanceof StashUserAuthenticationToken) {
            principal = ((StashUserAuthenticationToken)principal).getPrincipal();
        }
        if (!(principal instanceof ApplicationUser)) {
            return false;
        }
        ApplicationUser user = (ApplicationUser)principal;
        return user.getType() == UserType.SERVICE || user.isActive() && this.isUserLicensed(user);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanLicenseUser(ApplicationUser user, Permission permission) throws LicenseLimitException {
        if (!Permission.LICENSED_USER.getInheritingPermissions().contains(permission)) {
            return;
        }
        BitbucketServerLicense license = this.get();
        if (license == null || license.isUnlimitedNumberOfUsers()) {
            return;
        }
        if (this.isUserLicensed(user)) {
            return;
        }
        int licenseLimit = license.getMaximumNumberOfUsers();
        int licenseCount = this.permissionService.getUsersWithPermission(Permission.LICENSED_USER).size();
        if (licenseCount < licenseLimit) {
            return;
        }
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.license.userlimit", new Object[]{user.getDisplayName(), licenseLimit});
        throw new LicenseLimitException(message);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanLicenseGroup(String group, Permission permission) throws LicenseLimitException {
        Page users;
        if (!Permission.LICENSED_USER.getInheritingPermissions().contains(permission)) {
            return;
        }
        BitbucketServerLicense license = this.get();
        if (license == null || license.isUnlimitedNumberOfUsers()) {
            return;
        }
        if (this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, group)) {
            return;
        }
        int licenseLimit = license.getMaximumNumberOfUsers();
        HashSet<String> licensedUsers = new HashSet<String>();
        licensedUsers.addAll(this.permissionService.getUsersWithPermission(Permission.LICENSED_USER));
        PageRequestImpl request = new PageRequestImpl(0, 1000);
        do {
            users = this.userService.findUsersByGroup(group, (PageRequest)request);
            for (ApplicationUser user : users.getValues()) {
                licensedUsers.add(IdentifierUtils.toLowerCase((String)user.getName()));
                if (licensedUsers.size() <= licenseLimit) continue;
                KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.license.grouplimit", new Object[]{group, licenseLimit});
                throw new LicenseLimitException(message);
            }
        } while ((request = users.getNextPageRequest()) != null);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public void validateCanAddUserToGroup(String name, String group) {
        if (!this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, group)) {
            return;
        }
        ApplicationUser user = this.userService.getUserByName(name, true);
        if (user != null) {
            this.validateCanLicenseUser(user, Permission.LICENSED_USER);
        }
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getValidityMessage() {
        return this.getLicenseValidityMessage(this.get());
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getOverLimitMessage() {
        return this.licenseLimitHandler.getMessage().orElse(null);
    }

    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getStatus() {
        return Optional.ofNullable(this.getValidityMessage()).orElse(this.getOverLimitMessage());
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BitbucketServerLicense set(@Nonnull String encoded) {
        return this.set(encoded, true, true);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BitbucketServerLicense set(@Nonnull String encoded, boolean checkForged) {
        return this.set(encoded, true, checkForged);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BitbucketServerLicense setUnvalidated(@Nonnull String encoded) {
        return this.set(encoded, false, false);
    }

    private DualLicense decodeLicense(String license) throws InvalidLicenseException {
        try {
            DualLicense dualLicense = this.licenseHelper.decode(license);
            if (dualLicense == null) {
                throw new InvalidLicenseException(this.i18nService.createKeyedMessage("bitbucket.license.not.included", new Object[]{ApplicationConstants.PRODUCT_NAME}));
            }
            return dualLicense;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLicenseException(this.i18nService.createKeyedMessage("bitbucket.license.invalid", new Object[0]));
        }
    }

    private KeyedMessage getLicenseValidityMessage(BitbucketServerLicense license) {
        if (license == null) {
            return this.i18nService.createKeyedMessage("bitbucket.license.no.license", new Object[0]);
        }
        if (this.isMirror()) {
            return null;
        }
        if (license.isExpired()) {
            if (license.isEvaluation()) {
                return this.i18nService.createKeyedMessage("bitbucket.license.evaluation.expired", new Object[0]);
            }
            return this.i18nService.createKeyedMessage("bitbucket.license.expired", new Object[0]);
        }
        if (license.getMaintenanceExpiryDate() != null && this.propertiesService.getBuildTimestamp().after(license.getMaintenanceExpiryDate())) {
            return this.i18nService.createKeyedMessage("bitbucket.license.unsupported.upgrade", new Object[]{ApplicationConstants.PRODUCT_NAME});
        }
        return null;
    }

    private boolean isMirror() {
        return this.propertiesService.getMode() == ApplicationMode.MIRROR;
    }

    private boolean isUserLicensed(ApplicationUser user) {
        return this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
    }

    private BitbucketServerLicense set(@Nonnull String encoded, boolean validate, boolean checkForged) {
        KeyedMessage validityMessage;
        if (StringUtils.isEmpty((CharSequence)encoded)) {
            throw new InvalidLicenseException(this.i18nService.createKeyedMessage("bitbucket.license.empty", new Object[0]));
        }
        DualLicense license = this.decodeLicense(encoded);
        if (!this.isMirror() && !license.isClusteringEnabled()) {
            throw new NotDataCenterLicenseException(this.i18nService.createKeyedMessage("bitbucket.license.not.data-center", new Object[0]));
        }
        if (checkForged && license.isForged()) {
            throw new InvalidLicenseException(this.i18nService.createKeyedMessage("bitbucket.license.forged", new Object[0]));
        }
        if (validate && (validityMessage = this.getLicenseValidityMessage((BitbucketServerLicense)license)) != null) {
            throw new InvalidLicenseException(validityMessage);
        }
        this.licenseHelper.set(encoded);
        SpringTransactionUtils.invokeAfterCommit(this.licenseCache::reset);
        return license;
    }
}

