/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.log;

import com.atlassian.bitbucket.dmz.log.DmzLoggingService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.log.LoggingService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.nutcluster.core.EntryAdapter;
import com.atlassian.nutcluster.core.EntryEvent;
import com.atlassian.nutcluster.core.EntryListener;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.internal.diagnostics.HealthMonitor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.log.LoggingManager;
import com.atlassian.stash.internal.log.LoggingSettingsChangedEvent;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(interfaces={LoggingService.class, DmzLoggingService.class})
@Service(value="loggingService")
public class ClusteredLoggingService
implements DmzLoggingService,
StatefulService {
    public static final String MAP_LOGGING_STATE = "logging.state";
    private static final Map<String, String> DEBUG_LOG_LEVELS = ImmutableMap.builder().put((Object)"ROOT", (Object)"INFO").put((Object)"com.atlassian.bitbucket", (Object)"DEBUG").put((Object)"com.atlassian.event.remote", (Object)"DEBUG").put((Object)"com.atlassian.stash", (Object)"DEBUG").put((Object)"org.hibernate", (Object)"INFO").put((Object)"org.springframework", (Object)"INFO").put((Object)HealthMonitor.class.getName(), (Object)"DEBUG").build();
    private static final String PREFIX_ORIGINAL_LOGGER = "__";
    private static final String DEBUG_LOGGING_KEY_ENABLED = "____DEBUG_LOGGING_ENABLED";
    private final String entryListenerSubscription;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final LoggingManager loggingManager;
    private final IMap<String, String> loggingState;
    private final InternalApplicationPropertiesService propertiesService;
    private final SecurityService securityService;

    @Autowired
    public ClusteredLoggingService(EventPublisher eventPublisher, NutclusterInstance nutclusterInstance, I18nService i18nService, LoggingManager loggingManager, InternalApplicationPropertiesService propertiesService, SecurityService securityService) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.loggingManager = loggingManager;
        this.propertiesService = propertiesService;
        this.securityService = securityService;
        this.loggingState = nutclusterInstance.getMap(MAP_LOGGING_STATE);
        this.entryListenerSubscription = this.loggingState.addEntryListener((EntryListener)new LoggingStateListener(), true);
    }

    @PostConstruct
    public void applySharedLevels() {
        Set keys = this.loggingState.keySet();
        if (keys.isEmpty()) {
            if (this.propertiesService.isDebugLoggingEnabled()) {
                this.persistDebugLoggingSettingSecured(true);
                this.enableDebugLogging();
            }
        } else {
            for (String key : keys) {
                if (key.equals(DEBUG_LOGGING_KEY_ENABLED)) {
                    this.persistDebugLoggingSettingIfMirror(true);
                    continue;
                }
                if (key.startsWith(PREFIX_ORIGINAL_LOGGER)) continue;
                this.loggingManager.setLevel(key, (String)this.loggingState.get((Object)key));
            }
        }
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        return new MdcState(MDC.getCopyOfContextMap());
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public String getLevel(String loggerName) {
        return this.loggingManager.getLevel(loggerName);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public String getRootLevel() {
        return this.getLevel("ROOT");
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public boolean isDebugLoggingEnabled() {
        return this.loggingState.containsKey((Object)DEBUG_LOGGING_KEY_ENABLED);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void setDebugLoggingEnabled(boolean enabled) {
        this.propertiesService.setDebugLoggingEnabled(enabled);
        if (enabled) {
            this.enableDebugLogging();
        } else {
            this.disableDebugLogging();
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void setLevel(String loggerName, String levelName) {
        if ((loggerName = StringUtils.trimToNull((String)loggerName)) == null) {
            throw new IllegalArgumentException(this.i18nService.getMessage("bitbucket.logging.logger.name.required", new Object[0]));
        }
        if (!this.loggingManager.isValidLevel(levelName)) {
            throw new IllegalArgumentException(this.i18nService.getMessage("bitbucket.logging.level.invalid", new Object[]{levelName}));
        }
        this.loggingState.put((Object)loggerName, (Object)levelName);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void setRootLevel(String levelName) {
        this.setLevel("ROOT", levelName);
    }

    @PreDestroy
    protected void onShutdown() {
        this.loggingState.removeEntryListener(this.entryListenerSubscription);
    }

    private void disableDebugLogging() {
        this.loggingState.remove((Object)DEBUG_LOGGING_KEY_ENABLED);
        boolean logLevelReset = false;
        for (String loggerName : DEBUG_LOG_LEVELS.keySet()) {
            if (!this.restoreStandardLogLevel(loggerName)) continue;
            logLevelReset = true;
        }
        if (logLevelReset) {
            this.publishSettingsChangedEvent(false);
        }
    }

    private void enableDebugLogging() {
        this.loggingState.put((Object)DEBUG_LOGGING_KEY_ENABLED, (Object)"true");
        AtomicBoolean logLevelChangedToDebug = new AtomicBoolean(false);
        DEBUG_LOG_LEVELS.forEach((loggerName, level) -> this.loggingManager.ifLevelUpgrade((String)loggerName, (String)level, (currentLevel, newLevel) -> {
            this.setLevel(PREFIX_ORIGINAL_LOGGER + loggerName, (String)currentLevel);
            this.setLevel((String)loggerName, (String)newLevel);
            logLevelChangedToDebug.set(true);
        }));
        if (logLevelChangedToDebug.get()) {
            this.publishSettingsChangedEvent(true);
        }
    }

    private void persistDebugLoggingSettingIfMirror(boolean debugLoggingEnabled) {
        if (this.propertiesService.getMode() == ApplicationMode.MIRROR) {
            this.persistDebugLoggingSettingSecured(debugLoggingEnabled);
        }
    }

    private void persistDebugLoggingSettingSecured(boolean debugLoggingEnabled) {
        this.securityService.withPermission(Permission.SYS_ADMIN, "Persisting debug logging state").call(() -> {
            this.propertiesService.setDebugLoggingEnabled(debugLoggingEnabled);
            return null;
        });
    }

    private void publishSettingsChangedEvent(boolean debugLoggingEnabled) {
        if (this.propertiesService.getMode() == ApplicationMode.MIRROR) {
            this.securityService.withPermission(Permission.SYS_ADMIN, "Publishing logging settings changed event").call(() -> {
                this.eventPublisher.publish((Object)new LoggingSettingsChangedEvent((Object)this, debugLoggingEnabled));
                return null;
            });
        } else {
            this.eventPublisher.publish((Object)new LoggingSettingsChangedEvent((Object)this, debugLoggingEnabled));
        }
    }

    private boolean restoreStandardLogLevel(String loggerName) {
        String originalLevel = (String)this.loggingState.get((Object)(PREFIX_ORIGINAL_LOGGER + loggerName));
        if (originalLevel != null) {
            this.loggingState.remove((Object)(PREFIX_ORIGINAL_LOGGER + loggerName));
            this.setLevel(loggerName, originalLevel);
            return true;
        }
        return false;
    }

    private class LoggingStateListener
    extends EntryAdapter<String, String> {
        private LoggingStateListener() {
        }

        public void entryAdded(EntryEvent<String, String> event) {
            this.entryUpdated(event);
        }

        public void entryEvicted(EntryEvent<String, String> event) {
            ClusteredLoggingService.this.restoreStandardLogLevel((String)event.getKey());
        }

        public void entryRemoved(EntryEvent<String, String> event) {
            if (((String)event.getKey()).equals(ClusteredLoggingService.DEBUG_LOGGING_KEY_ENABLED)) {
                if (!event.getMember().localMember()) {
                    ClusteredLoggingService.this.persistDebugLoggingSettingIfMirror(false);
                }
                return;
            }
            ClusteredLoggingService.this.restoreStandardLogLevel((String)event.getKey());
        }

        public void entryUpdated(EntryEvent<String, String> event) {
            if (((String)event.getKey()).equals(ClusteredLoggingService.DEBUG_LOGGING_KEY_ENABLED)) {
                if (!event.getMember().localMember()) {
                    ClusteredLoggingService.this.persistDebugLoggingSettingIfMirror(true);
                }
                return;
            }
            String loggerName = (String)event.getKey();
            if (!loggerName.startsWith(ClusteredLoggingService.PREFIX_ORIGINAL_LOGGER)) {
                ClusteredLoggingService.this.loggingManager.setLevel(loggerName, (String)event.getValue());
            }
        }
    }

    private static final class MdcState
    implements TransferableState {
        private final Map<String, String> state;

        private MdcState(Map<String, String> state) {
            this.state = state;
        }

        public void apply() {
            if (this.state != null) {
                MDC.setContextMap(this.state);
            }
        }

        public void remove() {
            MDC.clear();
        }
    }
}

