/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.log;

import ch.qos.logback.classic.Level;
import com.atlassian.stash.internal.log.LoggingManager;
import com.atlassian.stash.internal.logback.LogbackUtils;
import jakarta.annotation.Nonnull;
import java.util.function.BiConsumer;
import org.springframework.stereotype.Component;

@Component(value="loggingManager")
public class LogbackLoggingManager
implements LoggingManager {
    @Override
    @Nonnull
    public String getLevel(@Nonnull String loggerName) {
        Level effectiveLevel = LogbackUtils.getEffectiveLevel((String)loggerName);
        return effectiveLevel.levelStr;
    }

    @Override
    public void ifLevelUpgrade(@Nonnull String loggerName, @Nonnull String levelName, @Nonnull BiConsumer<String, String> callback) {
        Level currentLevel = LogbackUtils.getEffectiveLevel((String)loggerName);
        Level newLevel = LogbackUtils.toLevel((String)levelName);
        if (!newLevel.isGreaterOrEqual(currentLevel)) {
            callback.accept(currentLevel.levelStr, newLevel.levelStr);
        }
    }

    @Override
    public boolean isValidLevel(String levelName) {
        return LogbackUtils.toLevel((String)levelName, null) != null;
    }

    @Override
    public void setLevel(@Nonnull String loggerName, String levelName) {
        LogbackUtils.setLevel((String)loggerName, (String)levelName);
    }
}

