/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.mail.MailAuthType;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import com.atlassian.stash.internal.mail.JavaMailSenderFactory;
import com.atlassian.stash.internal.mail.OAuthJavaMailSenderImpl;
import com.atlassian.stash.internal.mail.oauth2.AuthenticationContextFactory;
import com.atlassian.stash.internal.mail.oauth2.DefaultOAuth2ServiceFactory;
import com.atlassian.stash.internal.mail.oauth2.MailOAuth2Credentials;
import com.atlassian.stash.internal.mail.oauth2.OAuth2AuthenticationContext;
import com.atlassian.stash.internal.oauth2.OAuth2Exception;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Component;

@Component(value="javaMailSenderFactory")
public class DefaultJavaMailSenderFactory
implements JavaMailSenderFactory {
    private static final String MAIL_HOST = "mail.host";
    private static final String MAIL_PROTOCOL_AUTH_LOGIN_DISABLE = "mail.%s.auth.login.disable";
    private static final String MAIL_PROTOCOL_AUTH_PLAIN_DISABLE = "mail.%s.auth.plain.disable";
    private static final String MAIL_PROTOCOL_HOST = "mail.%s.host";
    private static final String MAIL_PROTOCOL_PORT = "mail.%s.port";
    private static final String MAIL_PROTOCOL_SASL_ENABLE = "mail.%s.sasl.enable";
    private static final String MAIL_PROTOCOL_SASL_MECHANISMS = "mail.%s.sasl.mechanisms";
    private static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static final String SMTP = "smtp";
    private static final String MAIL_SMTP = "mail.smtp";
    private static final String SMTPS = "smtps";
    private static final String MAIL_SMTPS = "mail.smtps";
    private static final String SMTP_ENABLE_STARTTLS = "mail.smtp.starttls.enable";
    private static final String SMTP_REQUIRE_STARTTLS = "mail.smtp.starttls.required";
    private static final Logger log = LoggerFactory.getLogger(DefaultJavaMailSenderFactory.class);
    private final AuthenticationContextFactory authenticationContextFactory;
    private final String cryptoCiphers;
    private final String cryptoProtocols;
    private final DefaultOAuth2ServiceFactory oauth2ServiceFactory;

    @Autowired
    public DefaultJavaMailSenderFactory(AuthenticationContextFactory authenticationContextFactory, DefaultOAuth2ServiceFactory oAuth2ServiceFactory, @Value(value="${mail.crypto.protocols}") String cryptoProtocols, @Value(value="${mail.crypto.ciphers}") String cryptoCiphers) {
        this.authenticationContextFactory = authenticationContextFactory;
        this.oauth2ServiceFactory = oAuth2ServiceFactory;
        this.cryptoProtocols = cryptoProtocols;
        this.cryptoCiphers = cryptoCiphers;
    }

    public JavaMailSenderImpl create(MailHostConfiguration configuration, int connectTimeout, int sendTimeout) {
        if (configuration == null || StringUtils.isBlank((CharSequence)configuration.getHostname())) {
            return null;
        }
        String prefix = configuration.getProtocol() == MailProtocol.SMTP ? MAIL_SMTP : MAIL_SMTPS;
        OAuth2AuthenticationContext authenticationContext = null;
        if (configuration.getAuthType() == MailAuthType.OAUTH2) {
            try {
                ClientTokenEntity token = this.oauth2ServiceFactory.getInstance().getToken(configuration.getTokenId());
                MailOAuth2Credentials creds = MailOAuth2Credentials.builder().userName(configuration.getUsername()).tokenId(token.getId()).accessToken(token.getAccessToken()).refreshToken(token.getRefreshToken()).status(token.getStatus()).build();
                authenticationContext = this.authenticationContextFactory.createAuthenticationContext(creds);
            }
            catch (OAuth2Exception e) {
                log.error("Failed to retrieve OAuth2 token", (Throwable)e);
            }
        }
        OAuthJavaMailSenderImpl sender = new OAuthJavaMailSenderImpl(authenticationContext, configuration.getAuthType());
        Properties properties = new Properties();
        sender.setDefaultEncoding("UTF-8");
        sender.setHost(configuration.getHostname());
        properties.put(MAIL_HOST, configuration.getHostname());
        if (configuration.getPort() != null) {
            sender.setPort(configuration.getPort());
        }
        String protocolName = configuration.getProtocol().name().toLowerCase(Locale.US);
        properties.put(MAIL_TRANSPORT_PROTOCOL, protocolName);
        sender.setProtocol(protocolName);
        properties.put(String.format(MAIL_PROTOCOL_HOST, protocolName), configuration.getHostname());
        if (configuration.getPort() != null) {
            properties.put(String.format(MAIL_PROTOCOL_PORT, protocolName), Integer.toString(configuration.getPort()));
        }
        if (configuration.getProtocol() == MailProtocol.SMTPS || configuration.isUseStartTls()) {
            if (StringUtils.isNotBlank((CharSequence)this.cryptoProtocols)) {
                properties.put(DefaultJavaMailSenderFactory.sslProtocolsProp(prefix), this.cryptoProtocols);
            }
            if (StringUtils.isNotBlank((CharSequence)this.cryptoCiphers)) {
                properties.put(DefaultJavaMailSenderFactory.sslCiphersProp(prefix), this.cryptoCiphers);
            }
        }
        if (configuration.getProtocol() == MailProtocol.SMTP) {
            if (configuration.isUseStartTls()) {
                properties.setProperty(SMTP_ENABLE_STARTTLS, Boolean.TRUE.toString());
            }
            if (configuration.isRequireStartTls()) {
                properties.setProperty(SMTP_REQUIRE_STARTTLS, Boolean.TRUE.toString());
            }
        }
        if (connectTimeout > 0) {
            properties.setProperty(DefaultJavaMailSenderFactory.connectionTimeoutProp(prefix), String.valueOf(connectTimeout));
        }
        if (sendTimeout > 0) {
            properties.setProperty(DefaultJavaMailSenderFactory.sendTimeoutProp(prefix), String.valueOf(sendTimeout));
        }
        if (StringUtils.isNotBlank((CharSequence)configuration.getUsername())) {
            properties.setProperty(DefaultJavaMailSenderFactory.authProp(prefix), Boolean.TRUE.toString());
            sender.setUsername(configuration.getUsername());
            if (StringUtils.isNotBlank((CharSequence)configuration.getPassword())) {
                sender.setPassword(configuration.getPassword());
            }
        }
        if (configuration.getAuthType() == MailAuthType.OAUTH2) {
            properties.put(String.format(MAIL_PROTOCOL_SASL_ENABLE, protocolName), "true");
            properties.put(String.format(MAIL_PROTOCOL_SASL_MECHANISMS, protocolName), "XOAUTH2");
            properties.put(String.format(MAIL_PROTOCOL_AUTH_LOGIN_DISABLE, protocolName), "true");
            properties.put(String.format(MAIL_PROTOCOL_AUTH_PLAIN_DISABLE, protocolName), "true");
        }
        sender.setJavaMailProperties(properties);
        return sender;
    }

    private static String authProp(String prefix) {
        return prefix + ".auth";
    }

    private static String connectionTimeoutProp(String prefix) {
        return prefix + ".connectiontimeout";
    }

    private static String sendTimeoutProp(String prefix) {
        return prefix + ".timeout";
    }

    private static String sslCiphersProp(String prefix) {
        return prefix + ".ssl.ciphers";
    }

    private static String sslProtocolsProp(String prefix) {
        return prefix + ".ssl.protocols";
    }
}

