/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.util.TextUtils;
import com.atlassian.stash.internal.logback.LoggingConstants;
import com.atlassian.stash.internal.mail.MailLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailLogger
implements MailLogger {
    private static final Logger log = LoggerFactory.getLogger(DefaultMailLogger.class);
    private static final Logger mailLog = LoggerFactory.getLogger((String)LoggingConstants.LOGGER_MAIL);
    private final long logPauseMillis;
    private long dropped = 0L;
    private long nextLog = 0L;
    private long sent = 0L;

    public DefaultMailLogger(int logPauseSeconds) {
        Preconditions.checkArgument((logPauseSeconds >= 0 ? 1 : 0) != 0, (Object)"mail.error.pause.log is less than 0");
        this.logPauseMillis = TimeUnit.SECONDS.toMillis(logPauseSeconds);
    }

    @Override
    public void logDebugMessage(String message, Object ... args) {
        if (this.getMailLog().isDebugEnabled()) {
            this.getMailLog().debug(message, args);
            this.flush();
        }
    }

    @Override
    public void logInfoMessage(String message, Object ... args) {
        this.getMailLog().info(message, args);
        this.flush();
    }

    @Override
    public void logWarnMessage(String message, Object ... args) {
        this.getMailLog().warn(message, args);
        this.flush();
    }

    @Override
    public void logSendError(String description, MailMessage mailMessage) {
        this.getMailLog().error(this.makeLogMessage(description, mailMessage));
        this.markSend(false);
    }

    @Override
    public void logSendError(String description, MailMessage mailMessage, Exception e) {
        this.getMailLog().error(this.makeLogMessage(description, mailMessage), (Throwable)e);
        this.markSend(false);
    }

    @Override
    public void logSendSuccess(String description, MailMessage mailMessage) {
        if (this.getMailLog().isTraceEnabled()) {
            this.getMailLog().trace(this.makeLogMessage(description, mailMessage));
        }
        this.markSend(true);
    }

    private String makeLogMessage(String description, MailMessage mailMessage) {
        StringBuilder builder = new StringBuilder(description);
        builder.append("; recipient: ").append(StringUtils.join((Iterable)mailMessage.getTo(), (String)","));
        builder.append("; subject: ").append(mailMessage.getSubject());
        if (this.getMailLog().isDebugEnabled()) {
            builder.append("; body: ").append(mailMessage.getText());
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markSend(boolean success) {
        DefaultMailLogger defaultMailLogger = this;
        synchronized (defaultMailLogger) {
            if (success) {
                ++this.sent;
            } else {
                ++this.dropped;
            }
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        long dropCount = 0L;
        long sendCount = 0L;
        boolean flush = false;
        DefaultMailLogger defaultMailLogger = this;
        synchronized (defaultMailLogger) {
            long now = this.currentTimeMillis();
            if (now > this.nextLog) {
                flush = true;
                dropCount = this.dropped;
                sendCount = this.sent;
                if (sendCount >= 0L || dropCount >= 0L) {
                    this.dropped = 0L;
                    this.sent = 0L;
                }
                this.nextLog = now + this.logPauseMillis;
            }
        }
        if (flush) {
            if (sendCount >= 1L || dropCount >= 1L) {
                this.getMailLog().info("{} {} sent: {} successful, {} failed", new Object[]{sendCount + dropCount, TextUtils.pluralise((String)"message", (long)dropCount), sendCount, dropCount});
            }
            if (dropCount >= 1L) {
                this.getLog().warn("{} mail {} not sent due to errors ({} sent successfully): see mail log for details", new Object[]{dropCount, TextUtils.pluralise((String)"message", (long)dropCount), sendCount});
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    @VisibleForTesting
    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    Logger getLog() {
        return log;
    }

    @VisibleForTesting
    Logger getMailLog() {
        return mailLog;
    }
}

