/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.stash.internal.mail.InsufficientSpaceOnMailQueueException;
import com.atlassian.stash.internal.mail.MailLogger;
import com.atlassian.stash.internal.mail.MailQueueSizeGuard;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class DefaultMailQueueSizeGuard
implements MailQueueSizeGuard {
    private final MailLogger mailLogger;
    private final long maxQueueSize;
    private final AtomicInteger queuedMessages;
    private final AtomicInteger queueSize;

    DefaultMailQueueSizeGuard(int maxQueueSize, MailLogger mailLogger) {
        this.mailLogger = mailLogger;
        Preconditions.checkArgument((maxQueueSize > 0 ? 1 : 0) != 0, (Object)"Max queue size can not be negative (mail.max.queue.size)");
        this.queuedMessages = new AtomicInteger(0);
        this.queueSize = new AtomicInteger(0);
        this.maxQueueSize = maxQueueSize;
    }

    @Override
    @Nonnull
    public MailQueueSizeGuard.Claim claimSpace(final int emailSize) {
        int newSize = this.queueSize.updateAndGet(currentSize -> {
            int requestedSize = currentSize + emailSize;
            if ((long)requestedSize > this.maxQueueSize) {
                throw new InsufficientSpaceOnMailQueueException();
            }
            return requestedSize;
        });
        int newCount = this.queuedMessages.incrementAndGet();
        this.mailLogger.logDebugMessage("Queue size is now {}kb with a depth of {}", newSize / 1024, newCount);
        return new MailQueueSizeGuard.Claim(){
            private AtomicBoolean released = new AtomicBoolean();

            @Override
            public void close() {
                if (this.released.compareAndSet(false, true)) {
                    DefaultMailQueueSizeGuard.this.queueSize.updateAndGet(currentSize -> {
                        int desiredSize = currentSize - emailSize;
                        if (desiredSize < 0) {
                            DefaultMailQueueSizeGuard.this.mailLogger.logWarnMessage("The queue size was not properly accounted: its estimated size was {} (now restored to {})", desiredSize, 0);
                            return 0;
                        }
                        return desiredSize;
                    });
                    DefaultMailQueueSizeGuard.this.queuedMessages.updateAndGet(currentCount -> Math.max(0, currentCount - 1));
                }
            }

            @Override
            public int getSize() {
                return emailSize;
            }
        };
    }

    @Override
    public int getQueuedMessageCount() {
        return this.queuedMessages.get();
    }

    @Override
    public double getQueueUsage() {
        return (double)Math.round(this.queueSize.doubleValue() / (double)this.maxQueueSize * 10.0) / 10.0;
    }

    @Override
    public int getReservedSize() {
        return this.queueSize.get();
    }
}

