/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.mail.InternalMailServiceStatistics;
import com.atlassian.stash.internal.mail.MailQueueSizeGuard;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;

public class DefaultMailServiceStatistics
implements InternalMailServiceStatistics {
    private final LinkedBlockingDeque<Long> averageMessageSizeWindow;
    private final Clock clock;
    private final Object counterLock;
    private final MailQueueSizeGuard mailQueueGuard;
    private volatile long averageMessageSize;
    private volatile long largestMessageSent;
    private volatile long lastMessageFailure;
    private volatile long lastMessageSuccess;
    private volatile long lastQueueFullEvent;
    private volatile long queueFullEventCount;
    private volatile long totalDataSent;
    private volatile long totalMessagesFailed;
    private volatile long totalMessagesSent;

    public DefaultMailServiceStatistics(@Nonnull Clock clock, @Nonnull MailQueueSizeGuard mailQueueGuard, int rollingAverageWindowSize) {
        this.averageMessageSizeWindow = new LinkedBlockingDeque(Math.min(65535, Math.max(1, rollingAverageWindowSize)));
        this.clock = Objects.requireNonNull(clock, "clock");
        this.counterLock = new Object();
        this.mailQueueGuard = Objects.requireNonNull(mailQueueGuard, "mailQueueGuard");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageMessageSize() {
        Object object = this.counterLock;
        synchronized (object) {
            return this.averageMessageSize / Math.max(1L, (long)this.averageMessageSizeWindow.size());
        }
    }

    public long getLargestMessageSent() {
        return this.largestMessageSent;
    }

    @Nullable
    public Date getLastMessageFailure() {
        return DefaultMailServiceStatistics.toDateOrNullForEpoch(this.lastMessageFailure);
    }

    @Nullable
    public Date getLastMessageSuccess() {
        return DefaultMailServiceStatistics.toDateOrNullForEpoch(this.lastMessageSuccess);
    }

    @Nullable
    public Date getLastQueueFullEvent() {
        return DefaultMailServiceStatistics.toDateOrNullForEpoch(this.lastQueueFullEvent);
    }

    public long getQueueFullEventCount() {
        return this.queueFullEventCount;
    }

    public double getQueueUsage() {
        return this.mailQueueGuard.getQueueUsage();
    }

    public long getQueuedMessagesCount() {
        return this.mailQueueGuard.getQueuedMessageCount();
    }

    public long getQueuedMessagesSize() {
        return this.mailQueueGuard.getReservedSize();
    }

    public long getTotalMailDataSent() {
        return this.totalDataSent;
    }

    public long getTotalMessagesFailed() {
        return this.totalMessagesFailed;
    }

    public long getTotalMessagesSent() {
        return this.totalMessagesSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageError() {
        Object object = this.counterLock;
        synchronized (object) {
            ++this.totalMessagesFailed;
            this.lastMessageFailure = this.clock.utcMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageQueueFull() {
        Object object = this.counterLock;
        synchronized (object) {
            ++this.queueFullEventCount;
            this.lastQueueFullEvent = this.clock.utcMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageSent(long messageSize) {
        Object object = this.counterLock;
        synchronized (object) {
            this.lastMessageSuccess = this.clock.utcMillis();
            this.totalDataSent += messageSize;
            ++this.totalMessagesSent;
            this.largestMessageSent = Math.max(this.largestMessageSent, messageSize);
            long newAverageMessageSize = this.averageMessageSize;
            newAverageMessageSize += messageSize;
            try {
                while (!this.averageMessageSizeWindow.offer(messageSize)) {
                    newAverageMessageSize -= this.averageMessageSizeWindow.removeFirst().longValue();
                }
                this.averageMessageSize = newAverageMessageSize;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.counterLock;
        synchronized (object) {
            this.averageMessageSizeWindow.clear();
            this.lastQueueFullEvent = 0L;
            this.lastMessageFailure = 0L;
            this.lastMessageSuccess = 0L;
            this.averageMessageSize = 0L;
            this.largestMessageSent = 0L;
            this.queueFullEventCount = 0L;
            this.totalDataSent = 0L;
            this.totalMessagesFailed = 0L;
            this.totalMessagesSent = 0L;
        }
    }

    private static Date toDateOrNullForEpoch(long timeMillis) {
        return timeMillis > 0L ? new Date(timeMillis) : null;
    }
}

