/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.event.server.MailHostConfigurationChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mail.MailAddressInvalidException;
import com.atlassian.bitbucket.mail.MailAttachment;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailQueueFullException;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.MailSizeExceededException;
import com.atlassian.bitbucket.mail.NoMailHostConfigurationException;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.TextUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.PauseableExecutorService;
import com.atlassian.stash.internal.mail.InsufficientSpaceOnMailQueueException;
import com.atlassian.stash.internal.mail.InternalMailService;
import com.atlassian.stash.internal.mail.InternalMailServiceStatistics;
import com.atlassian.stash.internal.mail.JavaMailSenderFactory;
import com.atlassian.stash.internal.mail.MailLogger;
import com.atlassian.stash.internal.mail.MailQueueSizeGuard;
import com.atlassian.stash.internal.mail.MailUtils;
import com.atlassian.stash.internal.mail.oauth2.OAuth2ChangeEvent;
import com.atlassian.stash.internal.mail.oauth2.OAuth2ReadyEvent;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import jakarta.annotation.Nullable;
import jakarta.mail.Address;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.SendFailedException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Conventions;
import org.springframework.mail.MailAuthenticationException;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.security.access.prepost.PreAuthorize;

public class MailServiceImpl
implements InternalMailService {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    private static final String mailSendTimer = Conventions.getQualifiedAttributeName(MailServiceImpl.class, (String)"sendMessageSynchronously");
    private final ApplicationPropertiesService applicationPropertiesService;
    private final I18nService i18nService;
    private final InternalMailServiceStatistics mailServiceStatistics;
    private final JavaMailSenderFactory senderFactory;
    private final MailLogger mailLogger;
    private final MailQueueSizeGuard guard;
    private final PauseableExecutorService pauseableExecutorService;
    private final long sendFailurePauseMillis;
    private final int maxMailSize;
    private final int maxShutdownWait;
    private final CachedReference<Maybe<JavaMailSender>> javaMailSender;
    private int connectTimeout;
    private int sendTimeout;
    private int testConnectTimeout;
    private int testSendTimeout;
    private boolean started;

    public MailServiceImpl(ApplicationPropertiesService propertiesService, I18nService i18nService, JavaMailSenderFactory senderFactory, PauseableExecutorService pauseableExecutorService, MailQueueSizeGuard mailQueueGuard, MailLogger mailLogger, CacheFactory cacheFactory, int sendFailurePauseSeconds, int maxMailSize, int maxShutdownWait, InternalMailServiceStatistics mailServiceStatistics) {
        Preconditions.checkArgument((sendFailurePauseSeconds >= 0 ? 1 : 0) != 0, (Object)"mail.error.pause.retry is less than 0");
        this.mailLogger = mailLogger;
        this.pauseableExecutorService = pauseableExecutorService;
        this.applicationPropertiesService = propertiesService;
        this.i18nService = i18nService;
        this.senderFactory = senderFactory;
        this.sendFailurePauseMillis = TimeUnit.SECONDS.toMillis(sendFailurePauseSeconds);
        this.mailServiceStatistics = mailServiceStatistics;
        this.maxMailSize = maxMailSize;
        this.maxShutdownWait = maxShutdownWait;
        this.guard = mailQueueGuard;
        this.javaMailSender = cacheFactory.getCachedReference(MailService.class, "StashMailConfiguration", this::buildMailSender, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build());
    }

    @EventListener
    public void onOAuth2ReadyEvent(OAuth2ReadyEvent event) {
        if (!this.started) {
            this.mailLogger.logInfoMessage("Starting mail service", new Object[0]);
            try {
                this.javaMailSender.get();
            }
            catch (Exception e) {
                this.mailLogger.logWarnMessage("Error while starting java mail service", e);
            }
            this.started = true;
        }
    }

    public void shutdown() {
        this.mailLogger.logInfoMessage("Shutting down mail service with a grace period of {}s", this.maxShutdownWait);
        this.pauseableExecutorService.shutdown();
        try {
            if (this.pauseableExecutorService.awaitTermination((long)Math.max(this.maxShutdownWait, 0), TimeUnit.SECONDS)) {
                this.mailLogger.logDebugMessage("Mail queue flushed successfully.", new Object[0]);
            } else {
                this.mailLogger.logWarnMessage("Mail queue flush timed out; shutting down.", new Object[0]);
                this.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.mailLogger.logWarnMessage("Mail queue flush interrupted; shutting down.", new Object[0]);
            Thread.currentThread().interrupt();
            this.shutdownNow();
        }
    }

    private void shutdownNow() {
        List unprocessedMessages = this.pauseableExecutorService.shutdownNow();
        int unprocessedCount = unprocessedMessages.size();
        if (unprocessedCount > 0) {
            String message = String.format("Discarding %d unsent mail %s", unprocessedCount, TextUtils.pluralise((String)"message", (long)unprocessedCount));
            this.mailLogger.logWarnMessage(message, new Object[0]);
        }
    }

    @Unsecured(value="this needs to be available in all contexts")
    public boolean isHostConfigured() {
        return ((Maybe)this.javaMailSender.get()).isDefined();
    }

    @EventListener
    public void onConfigChanged(MailHostConfigurationChangedEvent event) {
        this.clearCache();
        this.mailLogger.logInfoMessage("MailService reconfigured", new Object[0]);
    }

    @EventListener
    public void onOAuth2ChangeEvent(OAuth2ChangeEvent event) {
        this.clearCache();
    }

    @Profiled
    @Unsecured(value="currently we are not restricting messaging by permission")
    public void submit(MailMessage mailMessage) throws NoMailHostConfigurationException, MailQueueFullException {
        if (!this.isHostConfigured()) {
            throw this.throwNoMailHostConfiguredException(mailMessage);
        }
        int messageSize = this.checkMailSize(mailMessage);
        LocalDateTime enqueuedAt = LocalDateTime.now();
        try {
            MailQueueSizeGuard.Claim reservation = this.guard.claimSpace(messageSize);
            try {
                this.pauseableExecutorService.submit(() -> {
                    LocalDateTime sendStartedAt = LocalDateTime.now();
                    try (MailQueueSizeGuard.Claim ignored2 = reservation;){
                        String messageId = this.sendMessageSynchronously((JavaMailSender)((Maybe)this.javaMailSender.get()).get(), mailMessage);
                        this.handleMessageSuccess(messageId, mailMessage, messageSize, enqueuedAt, sendStartedAt);
                    }
                    catch (MailAddressInvalidException ignored2) {
                    }
                    catch (com.atlassian.bitbucket.mail.MailAuthenticationException | com.atlassian.bitbucket.mail.MailSendException ex) {
                        this.handleMessageFailure(mailMessage, messageSize, enqueuedAt, sendStartedAt, (Exception)ex);
                        this.pauseExecutorFor((com.atlassian.bitbucket.mail.MailException)ex);
                    }
                    catch (RuntimeException e) {
                        this.handleMessageFailure(mailMessage, messageSize, enqueuedAt, sendStartedAt, e);
                        this.mailLogger.logWarnMessage("Unexpected exception while sending email", e);
                    }
                });
            }
            catch (Exception e) {
                reservation.close();
                this.handleMessageFailure(mailMessage, messageSize, enqueuedAt, null, e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new com.atlassian.bitbucket.mail.MailSendException(this.getSendErrorMessage(), (Throwable)e);
            }
        }
        catch (InsufficientSpaceOnMailQueueException | RejectedExecutionException ex) {
            this.handleMessageFailure(mailMessage, messageSize, enqueuedAt, LocalDateTime.now(), ex);
            this.mailServiceStatistics.onMessageQueueFull();
            throw this.throwQueueFullException(mailMessage, ex);
        }
    }

    private void clearCache() {
        this.javaMailSender.reset();
        this.mailServiceStatistics.reset();
    }

    private MailQueueFullException throwQueueFullException(MailMessage mailMessage, Exception ex) {
        KeyedMessage errorMessage = this.i18nService.createKeyedMessage("bitbucket.service.mail.queuefull", new Object[]{mailMessage.getSubject()});
        this.mailLogger.logSendError(errorMessage.getLocalisedMessage(), mailMessage);
        throw new MailQueueFullException(errorMessage, (Throwable)ex);
    }

    private void pauseExecutorFor(com.atlassian.bitbucket.mail.MailException cause) {
        this.logExecutorPausing(cause, this::asWarnToMailLog);
        this.logExecutorPausing(cause, this::asWarnToGeneralLog);
        this.pauseableExecutorService.pauseFor(this.sendFailurePauseMillis, TimeUnit.MILLISECONDS);
    }

    @Unsecured(value="currently we are not restricting messaging by permission")
    public void sendNow(MailMessage message) throws MailException {
        Maybe javaMailSender = (Maybe)this.javaMailSender.get();
        if (javaMailSender.isEmpty()) {
            throw this.throwNoMailHostConfiguredException(message);
        }
        LocalDateTime sendStartedAt = LocalDateTime.now();
        int messageSize = MailUtils.computeSize(message);
        try {
            String messageId = this.sendMessageSynchronously((JavaMailSender)javaMailSender.get(), message);
            this.handleMessageSuccess(messageId, message, messageSize, null, sendStartedAt);
        }
        catch (InsufficientSpaceOnMailQueueException e) {
            this.mailServiceStatistics.onMessageQueueFull();
            this.handleMessageFailure(message, messageSize, null, sendStartedAt, e);
            throw e;
        }
        catch (MailException e) {
            this.handleMessageFailure(message, messageSize, null, sendStartedAt, (Exception)((Object)e));
            throw e;
        }
    }

    private NoMailHostConfigurationException throwNoMailHostConfiguredException(MailMessage mailMessage) throws NoMailHostConfigurationException {
        KeyedMessage errorMessage = this.i18nService.createKeyedMessage("bitbucket.service.noemailconfig", new Object[0]);
        NoMailHostConfigurationException e = new NoMailHostConfigurationException(errorMessage);
        this.mailLogger.logSendError(e.getLocalizedMessage(), mailMessage, (Exception)e);
        throw e;
    }

    private int checkMailSize(MailMessage message) throws MailSizeExceededException {
        int size = MailUtils.computeSize(message);
        if (size > this.maxMailSize) {
            MailSizeExceededException e = new MailSizeExceededException(this.i18nService.createKeyedMessage("bitbucket.service.mailsizeexceeded", new Object[]{size, this.maxMailSize}), size, this.maxMailSize);
            this.mailLogger.logSendError(e.getLocalizedMessage(), message, (Exception)e);
            throw e;
        }
        return size;
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void sendTest(MailHostConfiguration configuration, MailMessage message) throws MailException {
        this.sendMessageSynchronously(this.buildMailSender(configuration, this.testConnectTimeout, this.testSendTimeout), message);
    }

    private void logExecutorPausing(com.atlassian.bitbucket.mail.MailException cause, BiFunction<String, Object[], Void> fn) {
        fn.apply("Pausing sending of emails for {} seconds due to a previous {}", new Object[]{TimeUnit.MILLISECONDS.toSeconds(this.sendFailurePauseMillis), cause instanceof com.atlassian.bitbucket.mail.MailAuthenticationException ? "authentication error" : "error while sending"});
    }

    private Void asWarnToMailLog(String message, Object[] args) {
        this.mailLogger.logWarnMessage(message, args);
        return null;
    }

    private Void asWarnToGeneralLog(String message, Object[] args) {
        log.warn(message, args);
        return null;
    }

    private String sendMessageSynchronously(JavaMailSender javaMailSender, MailMessage message) throws MailException {
        try {
            String string;
            block15: {
                Timer ignored = TimerUtils.start((String)mailSendTimer);
                try {
                    this.checkMailSize(message);
                    MimeMessage mimeMessage = javaMailSender.createMimeMessage();
                    javaMailSender.send(this.newMimeMailMessagePreparator(message));
                    string = mimeMessage.getMessageID();
                    if (ignored == null) break block15;
                }
                catch (Throwable mimeMessage) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                mimeMessage.addSuppressed(throwable);
                            }
                        }
                        throw mimeMessage;
                    }
                    catch (MailAuthenticationException e) {
                        KeyedMessage errorMessage = this.translateAuthenticationFailure(e);
                        this.mailLogger.logSendError(errorMessage.getLocalisedMessage(), message, (Exception)((Object)e));
                        throw new com.atlassian.bitbucket.mail.MailAuthenticationException(errorMessage, (Throwable)e);
                    }
                    catch (MailSizeExceededException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Throwable wrapped;
                        KeyedMessage errorMessage;
                        Set<String> invalidAddresses = this.getInvalidAddressesFrom(e);
                        if (!invalidAddresses.isEmpty()) {
                            errorMessage = this.getInvalidAddressMessage(invalidAddresses);
                            wrapped = new MailAddressInvalidException(errorMessage, (Throwable)e);
                        } else {
                            errorMessage = this.getSendErrorMessage();
                            wrapped = new com.atlassian.bitbucket.mail.MailSendException(errorMessage, (Throwable)e);
                        }
                        this.mailLogger.logSendError(errorMessage.getLocalisedMessage(), message, e);
                        throw wrapped;
                    }
                }
                ignored.close();
            }
            return string;
        }
        finally {
            this.mailLogger.flush();
        }
    }

    private Set<String> getInvalidAddressesFrom(Exception e) {
        Throwable t;
        if (e instanceof MailParseException && (t = e.getCause()) instanceof AddressException) {
            return Collections.singleton(((AddressException)t).getRef());
        }
        if (e instanceof MailSendException) {
            return (Set)Arrays.stream(((MailSendException)e).getMessageExceptions()).filter(SendFailedException.class::isInstance).flatMap(ex -> Arrays.stream(Optional.ofNullable(((SendFailedException)ex).getInvalidAddresses()).orElse(new Address[0]))).map(Address::toString).collect(MoreCollectors.toImmutableSet());
        }
        return Collections.emptySet();
    }

    private KeyedMessage translateAuthenticationFailure(MailAuthenticationException e) {
        String message;
        if (e.getCause() instanceof AuthenticationFailedException && (StringUtils.containsIgnoreCase((CharSequence)(message = e.getCause().getMessage()), (CharSequence)"mechansims") || StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)"mechanisms"))) {
            return this.i18nService.createKeyedMessage("bitbucket.service.mail.no.mechanisms", new Object[0]);
        }
        return this.getDefaultAuthenticationErrorMessage();
    }

    private KeyedMessage getDefaultAuthenticationErrorMessage() {
        return this.i18nService.createKeyedMessage("bitbucket.service.mail.configurationerror", new Object[0]);
    }

    private KeyedMessage getSendErrorMessage() {
        return this.i18nService.createKeyedMessage("bitbucket.service.mail.sendfail", new Object[0]);
    }

    private KeyedMessage getInvalidAddressMessage(Set<String> addresses) {
        return this.i18nService.createKeyedMessage("bitbucket.service.mail.invalidaddress", new Object[]{String.join((CharSequence)", ", addresses)});
    }

    @Value(value="${mail.timeout.connect}")
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = this.toMilliseconds(connectTimeout);
    }

    @Value(value="${mail.timeout.send}")
    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = this.toMilliseconds(sendTimeout);
    }

    @Value(value="${mail.test.timeout.connect}")
    public void setTestConnectTimeout(int testConnectTimeout) {
        this.testConnectTimeout = this.toMilliseconds(testConnectTimeout);
    }

    @Value(value="${mail.test.timeout.send}")
    public void setTestSendTimeout(int testSendTimeout) {
        this.testSendTimeout = this.toMilliseconds(testSendTimeout);
    }

    private Option<JavaMailSender> buildMailSender() {
        return Option.option((Object)this.buildMailSender(this.applicationPropertiesService.getMailHostConfiguration(), this.connectTimeout, this.sendTimeout));
    }

    private JavaMailSender buildMailSender(MailHostConfiguration config, int connectTimeout, int sendTimeout) {
        return this.senderFactory.create(config, connectTimeout, sendTimeout);
    }

    private MimeMessagePreparator newMimeMailMessagePreparator(MailMessage mailMessage) {
        return mimeMessage -> {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, mailMessage.getAttachments().size() > 0);
            MimeMailMessage message = new MimeMailMessage(helper);
            message.setSubject(mailMessage.getSubject());
            message.setText(mailMessage.getText());
            message.setTo((String[])Iterables.toArray((Iterable)mailMessage.getTo(), String.class));
            if (mailMessage.hasFrom()) {
                message.setFrom(mailMessage.getFrom());
            } else {
                InternetAddress from = new InternetAddress(this.applicationPropertiesService.getServerEmailAddress());
                if (!StringUtils.isBlank((CharSequence)this.applicationPropertiesService.getDisplayName())) {
                    from.setPersonal(this.applicationPropertiesService.getDisplayName());
                }
                message.getMimeMessageHelper().setFrom(from);
            }
            if (mailMessage.hasCc()) {
                message.setCc((String[])Iterables.toArray((Iterable)mailMessage.getCc(), String.class));
            }
            if (mailMessage.hasBcc()) {
                message.setBcc((String[])Iterables.toArray((Iterable)mailMessage.getBcc(), String.class));
            }
            for (MailAttachment mailAttachment : mailMessage.getAttachments()) {
                helper.addAttachment(mailAttachment.getFileName(), mailAttachment.getSource());
            }
            for (Map.Entry entry : mailMessage.getHeaders().entrySet()) {
                mimeMessage.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        };
    }

    private int toMilliseconds(int seconds) {
        return Ints.checkedCast((long)TimeUnit.SECONDS.toMillis(seconds));
    }

    private void handleMessageDone(String statusMessage, String messageId, MailMessage mailMessage, int messageSize, @Nullable LocalDateTime enqueuedAt, LocalDateTime sendStartedAt, @Nullable Exception error) {
        if (this.mailLogger.isDebugEnabled()) {
            Duration timeToSend = Duration.between(sendStartedAt, LocalDateTime.now());
            String messageDetail = MessageFormat.format("message ID={0} subject={1} recipient={2} size={3}", messageId == null ? "-" : messageId, mailMessage.getSubject(), mailMessage.getTo(), messageSize);
            String messageSendDetail = MessageFormat.format("sent at={0} send for={1}ms", DateTimeFormatter.ISO_DATE_TIME.format(sendStartedAt), timeToSend.toMillis());
            String messageQueueDetail = null;
            if (enqueuedAt != null) {
                Duration timeInQueue = Duration.between(enqueuedAt, sendStartedAt);
                messageQueueDetail = MessageFormat.format("enqueued at={0} queued for={1}ms", DateTimeFormatter.ISO_DATE_TIME.format(enqueuedAt), timeInQueue.toMillis());
            }
            String queueInfo = MessageFormat.format("queue used={0}% queued messages={1}", (int)(100.0 * this.guard.getQueueUsage()), this.guard.getQueuedMessageCount());
            this.mailLogger.logDebugMessage(Joiner.on((String)" ").skipNulls().join(Arrays.asList(this.i18nService.getMessage(statusMessage, new Object[0]), messageDetail, messageSendDetail, messageQueueDetail, queueInfo)), error);
        }
    }

    private void handleMessageFailure(MailMessage mailMessage, int messageSize, @Nullable LocalDateTime enqueuedAt, LocalDateTime sendStartedAt, @Nullable Exception error) {
        this.mailServiceStatistics.onMessageError();
        this.handleMessageDone("Message was not sent.", null, mailMessage, messageSize, enqueuedAt, sendStartedAt, error);
    }

    private void handleMessageSuccess(String messageId, MailMessage mailMessage, int messageSize, @Nullable LocalDateTime enqueuedAt, LocalDateTime sendStartedAt) {
        this.mailServiceStatistics.onMessageSent((long)messageSize);
        this.handleMessageDone("Message sent successfully.", messageId, mailMessage, messageSize, enqueuedAt, sendStartedAt, null);
    }
}

