/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.stash.internal.mail.MailServiceStatistics;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="mailSupportData")
public class MailSupportData
extends RootLevelSupportDataAppender {
    private static final String MAIL = "bitbucket.atst.mail";
    private static final String MAIL_PROTOCOL = "bitbucket.atst.mail.protocol";
    private static final String MAIL_REQUIRE_TLS = "bitbucket.atst.mail.require.tls";
    private static final String MAIL_SERVER_ADDRESS = "bitbucket.atst.mail.server.address";
    private static final String MAIL_SERVER_HOSTNAME = "bitbucket.atst.mail.server.hostname";
    private static final String MAIL_SERVER_NOT_CONFIGURED = "bitbucket.atst.mail.server.notconfigured";
    private static final String MAIL_SERVER_PORT = "bitbucket.atst.mail.server.port";
    private static final String MAIL_USERNAME = "bitbucket.atst.mail.username";
    private static final String MAIL_USE_TLS = "bitbucket.atst.mail.use.tls";
    private static final String MAIL_STATS = "bitbucket.atst.mail.stats";
    private static final String MAIL_STATS_MSGS = "bitbucket.atst.mail.stats.messages";
    private static final String MAIL_STATS_MSGS_SUCCESS_COUNT = "bitbucket.atst.mail.stats.messages.success.count";
    private static final String MAIL_STATS_MSGS_SUCCESS_LAST = "bitbucket.atst.mail.stats.messages.success.last";
    private static final String MAIL_STATS_MSGS_FAILED_COUNT = "bitbucket.atst.mail.stats.messages.failed.count";
    private static final String MAIL_STATS_MSGS_FAILED_LAST = "bitbucket.atst.mail.stats.messages.failed.last";
    private static final String MAIL_STATS_MSGS_SENT_SIZE = "bitbucket.atst.mail.stats.messages.sent.size";
    private static final String MAIL_STATS_MSGS_AVG_SIZE = "bitbucket.atst.mail.stats.messages.sent.size.avg";
    private static final String MAIL_STATS_MSGS_LARGEST_SIZE = "bitbucket.atst.mail.stats.messages.sent.size.largest";
    private static final String MAIL_STATS_QUEUE = "bitbucket.atst.mail.stats.queue";
    private static final String MAIL_STATS_QUEUE_PERCENTAGE = "bitbucket.atst.mail.stats.queue.used";
    private static final String MAIL_STATS_QUEUE_COUNT = "bitbucket.atst.mail.stats.queue.count";
    private static final String MAIL_STATS_QUEUE_SIZE = "bitbucket.atst.mail.stats.queue.size";
    private static final String MAIL_STATS_QUEUE_FULL_LAST = "bitbucket.atst.mail.stats.queue.full.last";
    private static final String MAIL_STATS_QUEUE_FULL_COUNT = "bitbucket.atst.mail.stats.queue.full.count";
    private final DateFormatter dateFormatter;
    private final I18nService i18nService;
    private final MailServiceStatistics mailServiceStatistics;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public MailSupportData(DateFormatter dateFormatter, I18nService i18nService, MailServiceStatistics mailServiceStatistics, ApplicationPropertiesService propertiesService) {
        this.dateFormatter = dateFormatter;
        this.i18nService = i18nService;
        this.mailServiceStatistics = mailServiceStatistics;
        this.propertiesService = propertiesService;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder mailInfoBuilder = supportDataBuilder.addCategory(MAIL).addValue(MAIL_SERVER_ADDRESS, this.propertiesService.getServerEmailAddress());
        MailHostConfiguration config = this.propertiesService.getMailHostConfiguration();
        if (config != null) {
            this.addConfiguredMailServiceInfo(mailInfoBuilder, config);
        } else {
            this.addNoMailServiceConfigInfo(mailInfoBuilder);
        }
    }

    private void addNoMailServiceConfigInfo(SupportDataBuilder supportDataBuilder) {
        String message = this.i18nService.getMessage(MAIL_SERVER_NOT_CONFIGURED, new Object[0]);
        supportDataBuilder.addValue(MAIL_SERVER_HOSTNAME, message).addValue(MAIL_SERVER_PORT, message).addValue(MAIL_USERNAME, message).addValue(MAIL_PROTOCOL, message).addValue(MAIL_USE_TLS, message).addValue(MAIL_REQUIRE_TLS, message);
    }

    private void addConfiguredMailServiceInfo(SupportDataBuilder supportDataBuilder, MailHostConfiguration config) {
        supportDataBuilder.addValue(MAIL_SERVER_HOSTNAME, config.getHostname()).addValue(MAIL_SERVER_PORT, String.valueOf(config.getPort())).addValue(MAIL_USERNAME, config.getUsername()).addValue(MAIL_PROTOCOL, config.getProtocol().name());
        if (config.getProtocol() != MailProtocol.SMTPS) {
            supportDataBuilder.addValue(MAIL_USE_TLS, String.valueOf(config.isUseStartTls())).addValue(MAIL_REQUIRE_TLS, String.valueOf(config.isRequireStartTls()));
        }
        SupportDataBuilder mailStatsCategory = supportDataBuilder.addCategory(MAIL_STATS);
        mailStatsCategory.addCategory(MAIL_STATS_MSGS).addValue(MAIL_STATS_MSGS_SUCCESS_COUNT, String.valueOf(this.mailServiceStatistics.getTotalMessagesSent())).addValue(MAIL_STATS_MSGS_SUCCESS_LAST, this.dateOrDash(this.mailServiceStatistics.getLastMessageSuccess())).addValue(MAIL_STATS_MSGS_FAILED_COUNT, String.valueOf(this.mailServiceStatistics.getTotalMessagesFailed())).addValue(MAIL_STATS_MSGS_FAILED_LAST, this.dateOrDash(this.mailServiceStatistics.getLastMessageFailure())).addValue(MAIL_STATS_MSGS_SENT_SIZE, NumberUtils.formatSize((double)this.mailServiceStatistics.getTotalMailDataSent())).addValue(MAIL_STATS_MSGS_AVG_SIZE, NumberUtils.formatSize((double)this.mailServiceStatistics.getAverageMessageSize())).addValue(MAIL_STATS_MSGS_LARGEST_SIZE, NumberUtils.formatSize((double)this.mailServiceStatistics.getLargestMessageSent()));
        mailStatsCategory.addCategory(MAIL_STATS_QUEUE).addValue(MAIL_STATS_QUEUE_PERCENTAGE, String.valueOf(this.mailServiceStatistics.getQueueUsage())).addValue(MAIL_STATS_QUEUE_COUNT, String.valueOf(this.mailServiceStatistics.getQueuedMessagesCount())).addValue(MAIL_STATS_QUEUE_SIZE, NumberUtils.formatSize((double)this.mailServiceStatistics.getQueuedMessagesSize())).addValue(MAIL_STATS_QUEUE_FULL_COUNT, String.valueOf(this.mailServiceStatistics.getQueueFullEventCount())).addValue(MAIL_STATS_QUEUE_FULL_LAST, this.dateOrDash(this.mailServiceStatistics.getLastQueueFullEvent()));
    }

    @Nonnull
    private String dateOrDash(@Nullable Date date) {
        if (date == null || date.getTime() == 0L) {
            return "-";
        }
        return this.dateFormatter.formatDate(date, DateFormatter.FormatType.DATETIME);
    }
}

