/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.mail.MailAuthType;
import com.atlassian.stash.internal.mail.oauth2.OAuth2AuthenticationContext;
import jakarta.mail.MessagingException;
import jakarta.mail.Service;
import jakarta.mail.Transport;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class OAuthJavaMailSenderImpl
extends JavaMailSenderImpl {
    private final OAuth2AuthenticationContext authenticationContext;
    private final MailAuthType authType;

    public OAuthJavaMailSenderImpl(OAuth2AuthenticationContext authenticationContext, MailAuthType authType) {
        this.authenticationContext = authenticationContext;
        this.authType = authType;
    }

    protected Transport connectTransport() throws MessagingException {
        if (this.authType == MailAuthType.OAUTH2) {
            Transport transport = this.getTransport(this.getSession());
            this.authenticationContext.connectService((Service)transport);
            return transport;
        }
        return super.connectTransport();
    }
}

