/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mail.HtmlCssInliner;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.timezone.UserTimeZoneSupplier;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.locale.LocaleUtils;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.io.StringWriter;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=SoyMailBuilder.class)
@Component
public class SoyMailBuilderImpl
implements SoyMailBuilder {
    private static final Logger log = LoggerFactory.getLogger(SoyMailBuilderImpl.class);
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final HtmlCssInliner htmlCssInliner;
    private final I18nService i18nService;
    private final SecurityService securityService;
    private final InternalLocaleManager localeManager;
    private final UserService userService;
    private final UserTimeZoneSupplier userTimeZoneSupplier;

    @Autowired
    public SoyMailBuilderImpl(SoyTemplateRenderer soyTemplateRenderer, HtmlCssInliner htmlCssInliner, I18nService i18nService, SecurityService securityService, InternalLocaleManager localeManager, UserService userService, UserTimeZoneSupplier userTimeZoneSupplier) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.htmlCssInliner = htmlCssInliner;
        this.i18nService = i18nService;
        this.securityService = securityService;
        this.localeManager = localeManager;
        this.userService = userService;
        this.userTimeZoneSupplier = userTimeZoneSupplier;
    }

    @Nonnull
    public Iterable<MailMessage> build(@Nonnull SoyMailMessageRequest message) {
        Objects.requireNonNull(message, "message");
        return (Iterable)LocaleUtils.withoutLocale(() -> this.buildWithNoLocale(message));
    }

    private Iterable<MailMessage> buildWithNoLocale(SoyMailMessageRequest message) {
        HashSet<MailMessage> messages = new HashSet<MailMessage>();
        HashMap localeToMessage = Maps.newHashMap();
        for (ApplicationUser user : Chainable.chain((Iterable)message.getRecipients()).filter(recipient -> StringUtils.isNotBlank((CharSequence)recipient.getEmailAddress()))) {
            RecipientState recipientState = this.recipientStateFor(user);
            LocalizedMessage cachedMessage = (LocalizedMessage)localeToMessage.get(recipientState);
            if (cachedMessage == null) {
                cachedMessage = this.getLocalizedMessage(user, message, recipientState.locale);
                localeToMessage.put(recipientState, cachedMessage);
            }
            if (cachedMessage == null) continue;
            MailMessage.Builder mailMessageBuilder = new MailMessage.Builder().to(new String[]{user.getEmailAddress()}).text(cachedMessage.text).subject(cachedMessage.subject).header("Content-Type", "text/html; charset=UTF-8");
            if (cachedMessage.locale != null) {
                mailMessageBuilder.header("Content-Language", cachedMessage.locale.toLanguageTag());
            }
            mailMessageBuilder = (MailMessage.Builder)message.getMessageEffector().apply(mailMessageBuilder);
            messages.add(mailMessageBuilder.build());
        }
        return messages;
    }

    private LocalizedMessage getLocalizedMessage(ApplicationUser user, SoyMailMessageRequest message, Locale locale) {
        return (LocalizedMessage)this.securityService.impersonating(user, "Impersonate user for sending mail").call(() -> {
            try {
                String subjectText = null;
                if (message.getSubjectKey() != null) {
                    I18nKey subjectKey = message.getSubjectKey();
                    subjectText = this.i18nService.getMessage(subjectKey);
                }
                StringWriter writer = new StringWriter();
                ImmutableMap soyInjectedData = ImmutableMap.of((Object)"productName", (Object)Product.NAME, (Object)"systemServiceUser", (Object)this.userService.getSystemServiceUser());
                this.soyTemplateRenderer.render((Appendable)writer, message.getSoyTemplateModuleKey(), message.getSoyTemplateName(), message.getContext(), (Map)soyInjectedData);
                String text = this.htmlCssInliner.inlineCss(writer.toString(), message.getCssModuleKey());
                return new LocalizedMessage(locale, subjectText, text);
            }
            catch (SoyException e) {
                log.error("Error rendering email notification ({}/{})", new Object[]{message.getSoyTemplateModuleKey(), message.getSoyTemplateName(), e});
                return null;
            }
        });
    }

    private RecipientState recipientStateFor(ApplicationUser user) {
        return new RecipientState(this.localeManager.getLocale(user), this.userTimeZoneSupplier.getTimeZone(user));
    }

    private static class RecipientState {
        private final Locale locale;
        private final ZoneId zoneId;

        private RecipientState(Locale locale, ZoneId zoneId) {
            this.locale = locale;
            this.zoneId = zoneId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecipientState that = (RecipientState)o;
            return Objects.equals(this.locale, that.locale) && Objects.equals(this.zoneId, that.zoneId);
        }

        public int hashCode() {
            return Objects.hash(this.locale, this.zoneId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("locale", (Object)this.locale).add("zoneId", (Object)this.zoneId).toString();
        }
    }

    private static class LocalizedMessage {
        private final Locale locale;
        private final String subject;
        private final String text;

        private LocalizedMessage(Locale locale, String subject, String text) {
            this.locale = locale;
            this.subject = subject;
            this.text = text;
        }
    }
}

