/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail.oauth2;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.client.api.lib.flow.FlowRequestService;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigStorageService;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenStorageService;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.stash.internal.mail.oauth2.OAuth2ChangeEvent;
import com.atlassian.stash.internal.mail.oauth2.OAuth2ReadyEvent;
import com.atlassian.stash.internal.oauth2.DefaultOAuth2Service;
import com.atlassian.stash.internal.oauth2.OAuth2Service;
import com.atlassian.stash.internal.oauth2.OAuth2ServiceFactory;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DefaultOAuth2ServiceFactory
implements OAuth2ServiceFactory {
    private static final ImmutableList<Class<?>> CLASSES = ImmutableList.of(ClientConfigStorageService.class, ClientTokenStorageService.class, FlowRequestService.class, TokenHandler.class);
    private final OsgiContainerManager containerManager;
    private final EventPublisher eventPublisher;
    private final Map<Class<?>, Object> loadedClasses = new HashMap();
    private final Map<Class<?>, ServiceTracker<?, ?>> serviceTrackers;
    private BundleContext bundleContext;
    private OAuth2Service instance;

    public DefaultOAuth2ServiceFactory(OsgiContainerManager containerManager, EventPublisher eventPublisher) {
        this.containerManager = containerManager;
        this.eventPublisher = eventPublisher;
        this.serviceTrackers = new HashMap();
    }

    @Nonnull
    public OAuth2Service getInstance() throws IllegalStateException {
        if (this.instance == null) {
            throw new IllegalStateException("attempt to access OAuth2Service before oauth plugin loaded");
        }
        return this.instance;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.bundleContext = this.containerManager.getBundles()[0].getBundleContext();
        for (Class c : CLASSES) {
            this.serviceTrackers.put(c, this.makeServiceTracker(this.bundleContext, c));
        }
    }

    private void buildService() {
        this.instance = new DefaultOAuth2Service(this.getService(ClientConfigStorageService.class), this.getService(ClientTokenStorageService.class), this.getService(FlowRequestService.class), this.getService(TokenHandler.class));
    }

    private void checkPublishChangeEvent() {
        if (this.loadedClasses.keySet().containsAll((Collection<?>)CLASSES)) {
            this.buildService();
            this.eventPublisher.publish((Object)new OAuth2ChangeEvent());
        } else if (this.instance != null) {
            this.instance = null;
            this.eventPublisher.publish((Object)new OAuth2ChangeEvent());
        }
    }

    private void checkPublishReadyEvent() {
        if (this.loadedClasses.keySet().containsAll((Collection<?>)CLASSES)) {
            this.buildService();
            this.eventPublisher.publish((Object)new OAuth2ReadyEvent());
        }
    }

    private <C> C getService(Class<C> serviceClass) {
        Object service = this.loadedClasses.get(serviceClass);
        if (service == null) {
            throw new IllegalStateException("attempt to access " + serviceClass.getName() + " before it is loaded");
        }
        return (C)service;
    }

    private <C> ServiceTracker<C, C> makeServiceTracker(BundleContext bundleContext, Class<C> clazz) {
        ServiceTracker clientConfigStorageService = new ServiceTracker(bundleContext, clazz, new Customizer<C>(clazz));
        clientConfigStorageService.open();
        return clientConfigStorageService;
    }

    private class Customizer<C>
    implements ServiceTrackerCustomizer<C, C> {
        private final Class<C> clazz;

        public Customizer(Class<C> clazz) {
            this.clazz = clazz;
        }

        public C addingService(ServiceReference<C> reference) {
            Object addedService = DefaultOAuth2ServiceFactory.this.bundleContext.getService(reference);
            DefaultOAuth2ServiceFactory.this.loadedClasses.put(this.clazz, Objects.requireNonNull(addedService, this.clazz.getName()));
            DefaultOAuth2ServiceFactory.this.checkPublishReadyEvent();
            return (C)addedService;
        }

        public void modifiedService(ServiceReference<C> reference, C service) {
            DefaultOAuth2ServiceFactory.this.loadedClasses.put(this.clazz, Objects.requireNonNull(service, this.clazz.getName()));
            DefaultOAuth2ServiceFactory.this.checkPublishChangeEvent();
        }

        public void removedService(ServiceReference<C> reference, C service) {
            DefaultOAuth2ServiceFactory.this.loadedClasses.remove(this.clazz);
            DefaultOAuth2ServiceFactory.this.checkPublishChangeEvent();
        }
    }
}

