/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail.oauth2;

import com.atlassian.oauth2.client.api.ClientTokenMetadata;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class MailOAuth2Credentials {
    private final String accessToken;
    private final Properties properties;
    private final String refreshToken;
    private final ClientTokenMetadata.ClientTokenStatus status;
    private final String tokenId;
    private final String userName;

    private MailOAuth2Credentials(Builder builder) {
        this.accessToken = builder.accessToken;
        this.properties = builder.properties;
        this.refreshToken = builder.refreshToken;
        this.status = builder.status;
        this.tokenId = builder.tokenId;
        this.userName = builder.userName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailOAuth2Credentials)) {
            return false;
        }
        MailOAuth2Credentials that = (MailOAuth2Credentials)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.tokenId, that.tokenId) && Objects.equals(this.properties, that.properties) && Objects.equals(this.status, that.status);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Optional<Properties> getProperties() {
        return Optional.ofNullable(this.properties);
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public ClientTokenMetadata.ClientTokenStatus getStatus() {
        return this.status;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getUserName() {
        return this.userName;
    }

    public final int hashCode() {
        return Objects.hash(this.userName, this.accessToken, this.refreshToken, this.tokenId, this.properties, this.status);
    }

    public static class Builder {
        private String accessToken;
        private Properties properties;
        private String refreshToken;
        private ClientTokenMetadata.ClientTokenStatus status = ClientTokenMetadata.ClientTokenStatus.UNKNOWN;
        private String tokenId;
        private String userName;

        Builder() {
        }

        public Builder accessToken(@Nonnull String value) {
            this.accessToken = Objects.requireNonNull(value, "accessToken");
            return this;
        }

        public MailOAuth2Credentials build() {
            return new MailOAuth2Credentials(this);
        }

        public Builder properties(@Nonnull Properties value) {
            this.properties = Objects.requireNonNull(value, "properties");
            return this;
        }

        public Builder refreshToken(String value) {
            this.refreshToken = value;
            return this;
        }

        public Builder status(@Nonnull ClientTokenMetadata.ClientTokenStatus value) {
            this.status = Objects.requireNonNull(value, "status");
            return this;
        }

        public Builder tokenId(@Nonnull String value) {
            this.tokenId = Objects.requireNonNull(value, "tokenId");
            return this;
        }

        public Builder userName(String value) {
            this.userName = value;
            return this;
        }
    }
}

