/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.latch.Latch;
import com.atlassian.stash.internal.maintenance.latch.LatchableService;
import org.springframework.aop.support.AopUtils;

public abstract class AbstractUnlatchTask<L extends Latch>
extends AbstractMaintenanceTask {
    protected final I18nService i18nService;
    private final LatchableService<L> latchableService;
    private volatile boolean unlatched;

    protected AbstractUnlatchTask(I18nService i18nService, LatchableService<L> latchableService) {
        this.i18nService = i18nService;
        this.latchableService = latchableService;
    }

    public void run() {
        if (this.unlatched) {
            throw new IllegalStateException(this.getTypeName() + " already unlatched");
        }
        Latch latch = this.latchableService.getCurrentLatch();
        if (latch == null) {
            throw new IllegalStateException(this.getTypeName() + " not latched");
        }
        this.unlatch(latch);
        this.unlatched = true;
    }

    protected void unlatch(L latch) {
        latch.unlatch();
    }

    protected boolean isUnlatched() {
        return this.unlatched;
    }

    private String getTypeName() {
        return AopUtils.getTargetClass(this.latchableService).getSimpleName();
    }
}

