/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatusSupplier;
import jakarta.annotation.Nonnull;

public class ClusteredMaintenanceTaskStatusSupplier
implements MaintenanceTaskStatusSupplier {
    private final MaintenanceTaskStatusSupplier delegate;
    private final ITopic<MaintenanceTaskStatus> topic;
    private volatile String listenerId;

    public ClusteredMaintenanceTaskStatusSupplier(MaintenanceTaskStatusSupplier delegate, ITopic<MaintenanceTaskStatus> topic) {
        this.delegate = delegate;
        this.topic = topic;
    }

    public void addListener() {
        this.listenerId = this.topic.addMessageListener(message -> {
            if (!message.getPublishingMember().localMember()) {
                this.delegate.set((MaintenanceTaskStatus)message.getMessageObject());
            }
        });
    }

    @Override
    public MaintenanceTaskStatus get() {
        return this.delegate.get();
    }

    @EventListener
    public void onNodeAdded(ClusterNodeAddedEvent event) {
        MaintenanceTaskStatus status = this.delegate.get();
        if (status == null) {
            return;
        }
        boolean publishStatus = true;
        for (ClusterNode node : event.getCurrentNodes()) {
            if (!status.getOwnerNodeId().equals(node.getId())) continue;
            if (node.isLocal()) break;
            publishStatus = false;
            break;
        }
        if (publishStatus) {
            this.topic.publish((Object)status);
        }
    }

    public void removeListener() {
        String listenerId = this.listenerId;
        if (listenerId != null) {
            this.topic.removeMessageListener(listenerId);
        }
    }

    @Override
    public void set(@Nonnull MaintenanceTaskStatus status) {
        this.delegate.set(status);
        this.topic.publish((Object)status);
    }
}

