/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class CompositeMaintenanceTask
extends AbstractMaintenanceTask
implements MaintenanceTask {
    private volatile int currentStep = 0;
    private final Step[] steps;
    private final int totalWeight;

    protected CompositeMaintenanceTask(Step[] steps, int totalWeight) {
        this.steps = steps;
        this.totalWeight = totalWeight;
    }

    @Override
    public void cancel() {
        super.cancel();
        for (int i = this.currentStep; i < this.steps.length; ++i) {
            this.steps[i].cancel();
        }
    }

    @Nonnull
    public Progress getProgress() {
        int i;
        int curStep = this.currentStep;
        long completed = 0L;
        for (i = 0; i < curStep; ++i) {
            completed += (long)(100 * this.steps[i].getWeight());
        }
        for (i = curStep; i < this.steps.length; ++i) {
            completed += (long)Math.max(0, Math.min(100, this.steps[i].getProgress().getPercentage())) * (long)this.steps[i].getWeight();
        }
        Progress stepProgress = curStep < this.steps.length ? this.steps[curStep].getProgress() : this.steps[this.steps.length - 1].getProgress();
        double progressPercent = Math.ceil((double)completed * 1.0 / (double)this.totalWeight);
        return new ProgressImpl(stepProgress.getMessage(), (int)Math.round(progressPercent));
    }

    public void run() {
        this.currentStep = 0;
        while (this.currentStep < this.steps.length && !this.isCanceled()) {
            this.steps[this.currentStep].run();
            ++this.currentStep;
        }
    }

    protected static class Step
    implements MaintenanceTask {
        private final MaintenanceTask delegateTask;
        private final int weight;

        public Step(MaintenanceTask delegate, int weight) {
            this.delegateTask = delegate;
            this.weight = weight;
        }

        public void cancel() {
            this.delegateTask.cancel();
        }

        @Nonnull
        public Progress getProgress() {
            return this.delegateTask.getProgress();
        }

        public int getWeight() {
            return this.weight;
        }

        public void run() {
            this.delegateTask.run();
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder> {
        protected final List<Step> steps = Lists.newArrayList();
        protected int totalWeight;

        protected AbstractBuilder() {
        }

        @Nonnull
        public CompositeMaintenanceTask build() {
            Preconditions.checkState((!this.steps.isEmpty() ? 1 : 0) != 0, (Object)"at least one step must be provided");
            return new CompositeMaintenanceTask(this.steps.toArray(new Step[this.steps.size()]), this.totalWeight);
        }

        public B add(@Nonnull MaintenanceTask step, int weight) {
            Objects.requireNonNull(step, "step");
            Preconditions.checkArgument((weight >= 0 ? 1 : 0) != 0);
            this.steps.add(new Step(step, weight));
            this.totalWeight += weight;
            return this.self();
        }

        protected abstract B self();
    }
}

