/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.nutcluster.core.IAtomicLong;
import com.atlassian.nutcluster.core.IAtomicReference;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.MemberSelector;
import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.BaseMaintenanceCompletionCallback;
import com.atlassian.stash.internal.maintenance.ClusterMaintenanceLock;
import com.atlassian.stash.internal.maintenance.ClusterableTask;
import com.atlassian.stash.internal.maintenance.DefaultMaintenanceLock;
import com.atlassian.stash.internal.maintenance.DefaultMaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.IncorrectTokenMaintenanceException;
import com.atlassian.stash.internal.maintenance.InternalMaintenanceService;
import com.atlassian.stash.internal.maintenance.LockedMaintenanceException;
import com.atlassian.stash.internal.maintenance.MaintenanceCompletionCallback;
import com.atlassian.stash.internal.maintenance.MaintenanceLock;
import com.atlassian.stash.internal.maintenance.MaintenanceService;
import com.atlassian.stash.internal.maintenance.MaintenanceStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskState;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatusSupplier;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.maintenance.SimpleMaintenanceTaskStatus;
import com.atlassian.stash.internal.maintenance.UnsupportedMaintenanceException;
import com.atlassian.stash.internal.maintenance.latch.LatchState;
import com.atlassian.stash.internal.nutcluster.NodeIdMemberSelector;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;

public class DefaultMaintenanceService
extends AbstractSmartLifecycle
implements InternalMaintenanceService {
    private static final Object LOCK_LOCK = new Object();
    private static final Logger log = LoggerFactory.getLogger(DefaultMaintenanceService.class);
    private final AuthenticationContext authenticationContext;
    private final IExecutorService clusterExecutorService;
    private final IAtomicReference<ClusterMaintenanceLock> clusterLock;
    private final ClusterService clusterService;
    private final DatabaseManager databaseManager;
    private final EventPublisher eventPublisher;
    private final ScheduledExecutorService executorService;
    private final I18nService i18nService;
    private final IAtomicLong isActive;
    private final MaintenanceTaskStatusSupplier latestTask;
    private final RequestManager requestManager;
    private final Topic<Boolean> runningTaskCompletedTopic;
    private final InternalScmService scmService;
    private final MaintenanceStatus status;
    private final SecureTokenGenerator tokenGenerator;
    private long nodeJoinCheckDelayMillis;
    private String runningTaskCompletedTopicId;
    private volatile DefaultMaintenanceLock nodeLock;
    private volatile DefaultMaintenanceTaskMonitor runningTask;
    private volatile CountDownLatch runningTaskCompletedLatch;

    public DefaultMaintenanceService(AuthenticationContext authenticationContext, IExecutorService clusterExecutorService, ClusterService clusterService, DatabaseManager databaseManager, EventPublisher eventPublisher, ScheduledExecutorService executorService, I18nService i18nService, RequestManager requestManager, InternalScmService scmService, SecureTokenGenerator tokenGenerator, MaintenanceTaskStatusSupplier latestTask, IAtomicLong isActive, IAtomicReference<ClusterMaintenanceLock> clusterLock, TopicService topicService) {
        this.authenticationContext = authenticationContext;
        this.clusterExecutorService = clusterExecutorService;
        this.clusterLock = clusterLock;
        this.clusterService = clusterService;
        this.databaseManager = databaseManager;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.isActive = isActive;
        this.latestTask = latestTask;
        this.requestManager = requestManager;
        this.scmService = scmService;
        this.tokenGenerator = tokenGenerator;
        this.nodeJoinCheckDelayMillis = TimeUnit.SECONDS.toMillis(10L);
        this.status = new DefaultMaintenanceStatus();
        this.runningTaskCompletedTopic = topicService.getTopic("maintenance.runningtask.completed", TopicSettings.builder(Boolean.class).build());
    }

    public void clearClusterLock() {
        this.clusterLock.clear();
    }

    public void destroy() {
        DefaultMaintenanceTaskMonitor runningTask;
        if (this.runningTaskCompletedTopicId != null) {
            this.runningTaskCompletedTopic.unsubscribe(this.runningTaskCompletedTopicId);
        }
        if ((runningTask = this.runningTask) != null) {
            log.warn("Cancelling task {} in response to shutdown", (Object)runningTask.getId());
            if (!runningTask.cancel(runningTask.getCancelToken(), 10L, TimeUnit.SECONDS)) {
                log.warn("Timed out waiting for task {} to cancel in response to shutdown");
            }
        }
    }

    @Unsecured(value="The lock must be available while Johnson is preventing authentication")
    public MaintenanceLock getLock() {
        MaintenanceLock lock = (MaintenanceLock)this.clusterLock.get();
        if (lock == null && this.nodeLock != null) {
            log.warn("The local node is locked for maintenance, but the cluster is not locked!");
            return this.nodeLock;
        }
        return lock;
    }

    @Unsecured(value="The lock must be available while Johnson is preventing authentication")
    public MaintenanceLock getNodeLock() {
        return this.nodeLock;
    }

    public int getPhase() {
        return 200;
    }

    @Unsecured(value="Retrieving the running task cannot be secured; the database may not be available")
    public MaintenanceTaskMonitor getRunningTask() {
        if (this.runningTask != null) {
            return this.runningTask;
        }
        MaintenanceTaskStatus taskStatus = this.latestTask.get();
        if (taskStatus != null && taskStatus.getState() == MaintenanceTaskState.RUNNING) {
            return new RemoteMaintenanceTaskMonitor(taskStatus);
        }
        return null;
    }

    @Nonnull
    @Unsecured(value="Retrieving the status cannot be secured; the database may not be available")
    public MaintenanceStatus getStatus() {
        return this.status;
    }

    public void init() {
        this.runningTaskCompletedTopicId = this.runningTaskCompletedTopic.subscribe(event -> {
            if (!event.getSource().isLocal() && ((Boolean)event.getMessage()).booleanValue() && this.runningTaskCompletedLatch != null) {
                this.runningTaskCompletedLatch.countDown();
                log.debug("Released task completion latch");
            }
        });
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public MaintenanceLock lock() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.maintenance.lock.anonymousnotallowed", new Object[0]));
        }
        MaintenanceLock currentLock = (MaintenanceLock)this.clusterLock.get();
        while (currentLock == null) {
            ClusterMaintenanceLock newLock = new ClusterMaintenanceLock(user, this.tokenGenerator.generateToken(), this.clusterExecutorService, this.i18nService, this);
            if (this.clusterLock.compareAndSet(null, (Object)newLock)) {
                newLock.lock();
                return newLock;
            }
            currentLock = (MaintenanceLock)this.clusterLock.get();
        }
        log.warn("The system has already been locked for maintenance by {}", (Object)currentLock.getOwner().getDisplayName());
        throw new LockedMaintenanceException(this.i18nService.createKeyedMessage("bitbucket.service.maintenance.lock.locked", new Object[0]), currentLock.getOwner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unsecured(value="Only called from .lock > ClusterMaintenanceLock.lock _after_ SYS_ADMIN permissions have been checked (possibly on another node)")
    public void lockNode(@Nonnull MaintenanceLock maintenanceLock) {
        Object object = LOCK_LOCK;
        synchronized (object) {
            if (this.nodeLock == null) {
                DefaultMaintenanceLock lock = new DefaultMaintenanceLock(this.eventPublisher, this.i18nService, maintenanceLock.getOwner(), maintenanceLock.getUnlockToken());
                lock.addListener(() -> {
                    this.nodeLock = null;
                });
                lock.lock();
                log.info("The system has been locked for maintenance. It may be unlocked with token: {}", (Object)maintenanceLock.getUnlockToken());
                this.nodeLock = lock;
            } else {
                log.warn("The system has already been locked for maintenance by {}", (Object)this.nodeLock.getOwner().getDisplayName());
                if (!this.nodeLock.getUnlockToken().equals(maintenanceLock.getUnlockToken())) {
                    throw new LockedMaintenanceException(this.i18nService.createKeyedMessage("bitbucket.service.maintenance.lock.locked", new Object[0]), this.nodeLock.getOwner());
                }
            }
        }
    }

    @EventListener
    public void onNodeAdded(ClusterNodeAddedEvent event) {
        this.maybeLockOnJoin();
    }

    public void start() {
        super.start();
        this.maybeLockOnJoin();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public MaintenanceTaskMonitor start(@Nonnull MaintenanceTask task, @Nonnull MaintenanceType type) {
        Objects.requireNonNull(task, "task");
        if (this.clusterService.isClustered() && !task.getClass().isAnnotationPresent(ClusterableTask.class)) {
            throw new UnsupportedMaintenanceException(this.i18nService.createKeyedMessage("bitbucket.service.maintenance.task.unsupportedincluster", new Object[]{type}));
        }
        RequestContext requestContext = this.requestManager.getRequestContext();
        if (requestContext == null) {
            throw new IllegalStateException("Maintenance can only be started in the context of a user request, as performing maintenance may lock out the system and a user must have the ability to restore the system to a non-maintenance state");
        }
        if (this.isActive.compareAndSet(0L, 1L)) {
            try {
                String cancelToken = this.tokenGenerator.generateToken();
                String id = UUID.randomUUID().toString();
                DefaultMaintenanceTaskMonitor newTask = new DefaultMaintenanceTaskMonitor(task, id, type, this.clusterService.getNodeId(), requestContext.getSessionId(), cancelToken, this.i18nService);
                newTask.registerCallback(new BaseMaintenanceCompletionCallback(){

                    @Override
                    protected void onCompletion() {
                        if (DefaultMaintenanceService.this.isActive.compareAndSet(1L, 0L)) {
                            DefaultMaintenanceService.this.latestTask.set(new SimpleMaintenanceTaskStatus((MaintenanceTaskStatus)DefaultMaintenanceService.this.runningTask));
                            DefaultMaintenanceService.this.runningTask = null;
                            if (DefaultMaintenanceService.this.runningTaskCompletedLatch != null) {
                                DefaultMaintenanceService.this.runningTaskCompletedLatch.countDown();
                                log.debug("Released task completion latch for source node");
                            }
                            log.debug("Notifying other nodes of task completion");
                            DefaultMaintenanceService.this.runningTaskCompletedTopic.publish((Serializable)Boolean.valueOf(true));
                        }
                    }
                });
                this.runningTask = newTask;
                this.runningTask.submitTo(this.executorService);
                log.info("{} started with ID {}. It may be canceled with token: {}", new Object[]{type, id, cancelToken});
            }
            catch (RuntimeException e) {
                this.isActive.compareAndSet(1L, 0L);
                throw e;
            }
            this.latestTask.set(new SimpleMaintenanceTaskStatus((MaintenanceTaskStatus)this.runningTask));
            this.startMonitor();
            log.debug("Initializing completion latch for current maintenance task");
            this.runningTaskCompletedLatch = new CountDownLatch(1);
            return this.runningTask;
        }
        throw new IllegalStateException(String.valueOf(type) + " maintenance cannot be started; other maintenance is already in progress.");
    }

    @VisibleForTesting
    public void setNodeJoinCheckDelayMillis(long delay, TimeUnit timeUnit) {
        this.nodeJoinCheckDelayMillis = timeUnit.toMillis(delay);
    }

    @Unsecured(value="Retrieving the running task cannot be secured; the database may not be available")
    public boolean waitForTaskCompletion(@Nonnull Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        if (this.getRunningTask() == null || this.runningTaskCompletedLatch == null) {
            log.debug("No current task running");
            return true;
        }
        try {
            if (this.runningTaskCompletedLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                log.debug("Current task completed within the specified timeout");
                return true;
            }
            log.debug("Timed out waiting for current task to complete");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Wait for task completion interrupted", (Throwable)e);
        }
        return false;
    }

    private boolean lockIfClusterLocked() {
        MaintenanceLock lock;
        if (this.nodeLock == null && (lock = (MaintenanceLock)this.clusterLock.get()) != null) {
            log.info("Locking system for maintenance because the cluster is already locked");
            this.lockNode(lock);
            return true;
        }
        return false;
    }

    private void maybeLockOnJoin() {
        if (this.nodeLock == null && !this.lockIfClusterLocked()) {
            this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    DefaultMaintenanceService.this.lockIfClusterLocked();
                }
            }, this.nodeJoinCheckDelayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void startMonitor() {
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                DefaultMaintenanceTaskMonitor monitor = DefaultMaintenanceService.this.runningTask;
                if (monitor != null) {
                    DefaultMaintenanceService.this.latestTask.set(new SimpleMaintenanceTaskStatus((MaintenanceTaskStatus)monitor));
                    DefaultMaintenanceService.this.executorService.schedule(this, 1L, TimeUnit.SECONDS);
                }
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private class DefaultMaintenanceStatus
    implements MaintenanceStatus {
        private DefaultMaintenanceStatus() {
        }

        @Nonnull
        public LatchState getDatabaseState() {
            return DefaultMaintenanceService.this.databaseManager.getState();
        }

        public MaintenanceTaskStatus getLatestTask() {
            return DefaultMaintenanceService.this.latestTask.get();
        }

        @Nonnull
        public LatchState getScmState() {
            return DefaultMaintenanceService.this.scmService.getState();
        }
    }

    private class RemoteMaintenanceTaskMonitor
    extends SimpleMaintenanceTaskStatus
    implements MaintenanceTaskMonitor {
        private RemoteMaintenanceTaskMonitor(MaintenanceTaskStatus taskInfo) {
            super(taskInfo);
        }

        public void awaitCompletion() {
            throw new UnsupportedOperationException("Cannot await completion of remote tasks");
        }

        public boolean cancel(@Nonnull String token, long timeout, @Nonnull TimeUnit timeUnit) {
            Objects.requireNonNull(token, "token");
            Objects.requireNonNull(timeUnit, "unit");
            if (!this.getCancelToken().equals(token)) {
                throw new IncorrectTokenMaintenanceException(DefaultMaintenanceService.this.i18nService.createKeyedMessage("bitbucket.service.maintenance.task.incorrecttoken", new Object[0]), token);
            }
            Future result = DefaultMaintenanceService.this.clusterExecutorService.submit((Callable)new CancelMaintenance(token, timeout, timeUnit), (MemberSelector)new NodeIdMemberSelector(this.getOwnerNodeId()));
            try {
                return (Boolean)result.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.warn("Error while canceling maintenance", (Throwable)e);
            }
            return false;
        }

        public void registerCallback(MaintenanceCompletionCallback callback) {
            throw new UnsupportedOperationException("Cannot register callbacks on remote tasks");
        }
    }

    @SpringAware
    @VisibleForTesting
    static class CancelMaintenance
    implements Callable<Boolean>,
    Serializable {
        private final String cancelToken;
        private final long timeoutMillis;
        private transient MaintenanceService maintenanceService;

        private CancelMaintenance(String cancelToken, long timeout, TimeUnit timeUnit) {
            this.cancelToken = cancelToken;
            this.timeoutMillis = timeUnit.toMillis(timeout);
        }

        @Override
        public Boolean call() throws Exception {
            MaintenanceTaskMonitor task = this.maintenanceService.getRunningTask();
            return task != null && task.cancel(this.cancelToken, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }

        @Resource
        public void setMaintenanceService(MaintenanceService maintenanceService) {
            this.maintenanceService = maintenanceService;
        }
    }
}

