/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.nutcluster.core.ISet;
import com.atlassian.nutcluster.core.ItemEvent;
import com.atlassian.nutcluster.core.ItemListener;
import com.atlassian.stash.internal.maintenance.JohnsonMaintenanceEvent;
import com.atlassian.stash.internal.maintenance.MaintenanceModeHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;

public class NutclusterMaintenanceModeHelper
implements MaintenanceModeHelper,
ItemListener<JohnsonMaintenanceEvent> {
    private final MaintenanceModeHelper localMaintenanceModeHelper;
    private final Object lock = new Object();
    private final ISet<JohnsonMaintenanceEvent> maintenanceEvents;
    private String listenerRegistrationId;

    public NutclusterMaintenanceModeHelper(ISet<JohnsonMaintenanceEvent> maintenanceEvents, MaintenanceModeHelper localMaintenanceModeHelper) {
        this.localMaintenanceModeHelper = localMaintenanceModeHelper;
        this.maintenanceEvents = maintenanceEvents;
    }

    @PreDestroy
    public void destroy() {
        if (this.listenerRegistrationId != null) {
            this.maintenanceEvents.removeItemListener(this.listenerRegistrationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            this.listenerRegistrationId = this.maintenanceEvents.addItemListener((ItemListener)this, true);
            for (JohnsonMaintenanceEvent event : this.maintenanceEvents) {
                this.localMaintenanceModeHelper.lock(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemAdded(ItemEvent<JohnsonMaintenanceEvent> item) {
        Object object = this.lock;
        synchronized (object) {
            this.localMaintenanceModeHelper.lock((JohnsonMaintenanceEvent)item.getItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemRemoved(ItemEvent<JohnsonMaintenanceEvent> item) {
        Object object = this.lock;
        synchronized (object) {
            this.localMaintenanceModeHelper.unlock((JohnsonMaintenanceEvent)item.getItem());
        }
    }

    @Override
    public void lock(@Nonnull JohnsonMaintenanceEvent event) {
        this.maintenanceEvents.add((Object)event);
    }

    @Override
    public void unlock(@Nonnull JohnsonMaintenanceEvent event) {
        this.maintenanceEvents.remove((Object)event);
    }
}

