/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.db.DatabaseAffixed;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.migration.DatabaseMigrationException;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ReleaseAffixedDatabaseStep
extends AbstractMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(ReleaseAffixedDatabaseStep.class);
    private final List<DatabaseAffixed> affixes;
    private final I18nService i18nService;
    private volatile boolean released;

    @Autowired
    public ReleaseAffixedDatabaseStep(I18nService i18nService, List<DatabaseAffixed> affixes) {
        this.affixes = ImmutableList.copyOf(affixes);
        this.i18nService = i18nService;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("bitbucket.migration.releasingdatabase", new Object[0]), this.released ? 100 : 0);
    }

    public void run() {
        for (DatabaseAffixed affix : this.affixes) {
            if (this.isCanceled()) {
                return;
            }
            try {
                affix.release();
            }
            catch (Exception e) {
                Class componentClass = AopUtils.getTargetClass((Object)affix);
                log.error("{} failed to release the current database", (Object)componentClass.getName(), (Object)e);
                throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.releasedatabasefailed", new Object[0]));
            }
        }
        this.released = true;
    }
}

