/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.AbstractUnlatchTask;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class UnlatchDatabaseStep
extends AbstractUnlatchTask<DatabaseLatch> {
    private final DatabaseHandle target;

    private UnlatchDatabaseStep(Builder builder) {
        super(builder.i18nService, builder.databaseManager);
        this.target = builder.target;
    }

    @Nonnull
    public Progress getProgress() {
        String message = this.target == null ? this.i18nService.getMessage("bitbucket.backup.restore.resuming.database", new Object[0]) : this.i18nService.getMessage("bitbucket.backup.restore.switching.database", new Object[0]);
        return new ProgressImpl(message, this.isUnlatched() ? 100 : 0);
    }

    @Override
    protected void unlatch(DatabaseLatch latch) {
        if (this.target == null) {
            super.unlatch(latch);
        } else {
            latch.unlatchTo(this.target);
        }
    }

    public static class Builder {
        private final DatabaseManager databaseManager;
        private final I18nService i18nService;
        private DatabaseHandle target;

        public Builder(I18nService i18nService, DatabaseManager databaseManager) {
            this.databaseManager = databaseManager;
            this.i18nService = i18nService;
        }

        @Nonnull
        public UnlatchDatabaseStep build() {
            return new UnlatchDatabaseStep(this);
        }

        @Nonnull
        public Builder target(@Nullable DatabaseHandle target) {
            this.target = target;
            return this;
        }
    }
}

