/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.maintenance.CompositeMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupPhase
extends CompositeMaintenanceTask {
    public static final TimeZone TIMEZONE_FOR_TIMESTAMP = TimeZone.getTimeZone("UTC");
    public static final String FORMAT_UTC_TIMESTAMP = "yyyyMMdd-HHmmss-SSS'Z'";
    private static final Logger log = LoggerFactory.getLogger(BackupPhase.class);
    private final AuthenticationContext authenticationContext;
    private final HomeLayout homeLayout;
    private final I18nService i18nService;
    private final BackupState state;

    protected BackupPhase(AuthenticationContext authenticationContext, HomeLayout homeLayout, I18nService i18nService, BackupState state, CompositeMaintenanceTask.Step[] steps, int totalWeight) {
        super(steps, totalWeight);
        this.authenticationContext = authenticationContext;
        this.homeLayout = homeLayout;
        this.i18nService = i18nService;
        this.state = state;
    }

    @Override
    public void run() {
        Path backupDir = this.homeLayout.getBackupDir();
        if (!Files.isWritable(backupDir)) {
            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.cant.write", new Object[]{backupDir}));
        }
        Path backupFile = backupDir.resolve(this.getBackupFilename());
        boolean success = false;
        CloseShieldZipOutputStream zipStream = null;
        try {
            log.debug("Writing backup to {}", (Object)backupFile.toAbsolutePath());
            zipStream = new CloseShieldZipOutputStream(Files.newOutputStream(backupFile, new OpenOption[0]));
            this.state.setBackupFile(backupFile);
            this.state.setBackupZipStream(zipStream);
            super.run();
            success = true;
        }
        catch (Exception e) {
            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.create.failed", new Object[0]), (Throwable)e);
        }
        finally {
            if (zipStream != null) {
                try {
                    zipStream.reallyClose();
                }
                catch (IOException e) {
                    log.debug("Failed to close the backup zip", (Throwable)e);
                }
            }
            if (!success || this.isCanceled()) {
                try {
                    Files.delete(backupFile);
                    log.debug("Deleted partial backup file at {} after catching an exception", (Object)backupFile.toAbsolutePath());
                }
                catch (IOException e) {
                    log.debug("Failed to delete partial backup file at {}; the file has been marked for deletion on exit", (Object)backupFile.toAbsolutePath(), (Object)e);
                    backupFile.toFile().deleteOnExit();
                }
            }
        }
    }

    private String getBackupFilename() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        String username = currentUser == null ? "anonymous" : currentUser.getName();
        username = username.replaceAll("[^a-zA-Z0-9-_]", "_");
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_UTC_TIMESTAMP);
        format.setTimeZone(TIMEZONE_FOR_TIMESTAMP);
        String displayTimestamp = format.format(new Date());
        return String.format("%s-%s-%s.zip", "backup", username, displayTimestamp);
    }

    static class CloseShieldZipOutputStream
    extends ZipOutputStream {
        public CloseShieldZipOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void close() {
        }

        private void reallyClose() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.delegate != null) {
                    try {
                        this.delegate.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static class Builder
    extends CompositeMaintenanceTask.AbstractBuilder<Builder> {
        private final AuthenticationContext authenticationContext;
        private final HomeLayout homeLayout;
        private final I18nService i18nService;
        private final BackupState state;

        public Builder(AuthenticationContext authenticationContext, HomeLayout homeLayout, I18nService i18nService, BackupState state) {
            this.authenticationContext = authenticationContext;
            this.homeLayout = homeLayout;
            this.i18nService = i18nService;
            this.state = state;
        }

        @Override
        @Nonnull
        public BackupPhase build() {
            return new BackupPhase(this.authenticationContext, this.homeLayout, this.i18nService, this.state, this.steps.toArray(new CompositeMaintenanceTask.Step[0]), this.totalWeight);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

