/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class ChangelogsBackupStep
extends AbstractMaintenanceTask {
    public static final Pattern PATTERN_INCLUDE = Pattern.compile("\\s+<include file=\"([^\"]+)\"/>$");
    private static final String PATH_LIQUIBASE = "liquibase/";
    private static final String PATH_BOOTSTRAP = "liquibase/bootstrap.xml";
    private static final String PATH_MASTER = "liquibase/master.xml";
    private static final Logger log = LoggerFactory.getLogger(ChangelogsBackupStep.class);
    private final I18nService i18nService;
    private final BackupState state;
    private volatile int progress;

    public ChangelogsBackupStep(I18nService i18nService, BackupState state) {
        this.i18nService = i18nService;
        this.state = state;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("bitbucket.backup.changelog.save", new Object[0]), this.progress);
    }

    public void run() {
        ZipOutputStream stream = this.state.getBackupZipStream();
        Preconditions.checkState((stream != null ? 1 : 0) != 0, (Object)"A backup ZipOutputStream is required");
        try {
            ZipEntry entry = new ZipEntry("changelogs.zip");
            stream.putNextEntry(entry);
            log.debug("Backing up database changelogs to {}", (Object)"changelogs.zip");
            try (ZipOutputStream zip = new ZipOutputStream((OutputStream)new CloseShieldOutputStream((OutputStream)stream));){
                this.writeDatabaseChangelogBackup(zip);
            }
            stream.closeEntry();
        }
        catch (IOException e) {
            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.changelogs.failed", new Object[]{Product.NAME}), (Throwable)e);
        }
    }

    private void writeDatabaseChangelogBackup(ZipOutputStream stream) throws IOException {
        stream.putNextEntry(new ZipEntry(PATH_LIQUIBASE));
        stream.putNextEntry(new ZipEntry(PATH_BOOTSTRAP));
        Set paths = (Set)new ChangeLogSource(PATH_BOOTSTRAP, (OutputStream)stream).readLines(new PathLineHandler());
        stream.putNextEntry(new ZipEntry(PATH_MASTER));
        paths.addAll((Collection)new ChangeLogSource(PATH_MASTER, (OutputStream)stream).readLines(new PathLineHandler()));
        paths.remove(PATH_BOOTSTRAP);
        paths.remove(PATH_MASTER);
        int processed = 2;
        int total = paths.size() + processed;
        for (String path : paths) {
            this.progress = 100 * processed / total;
            stream.putNextEntry(new ZipEntry(path));
            ByteStreams.copy((InputStream)new ClassPathResource(path).getInputStream(), (OutputStream)stream);
            ++processed;
        }
        this.progress = 100;
    }

    private static final class ChangeLogSource
    extends CharSource {
        private final String changeLogPath;
        private final OutputStream outputStream;

        private ChangeLogSource(String changeLogPath, OutputStream outputStream) {
            this.outputStream = outputStream;
            this.changeLogPath = changeLogPath;
        }

        public Reader openStream() throws IOException {
            ClassPathResource changeLog = new ClassPathResource(this.changeLogPath);
            TeeInputStream input = new TeeInputStream(changeLog.getInputStream(), this.outputStream, false);
            InputStreamReader reader = new InputStreamReader((InputStream)input, Charsets.UTF_8);
            return new BufferedReader(reader);
        }
    }

    private static final class PathLineHandler
    implements LineProcessor<Set<String>> {
        private final Set<String> paths = Sets.newLinkedHashSet();

        private PathLineHandler() {
        }

        public Set<String> getResult() {
            return this.paths;
        }

        public boolean processLine(@Nonnull String line) throws IOException {
            Matcher matcher = PATTERN_INCLUDE.matcher(line);
            if (matcher.matches()) {
                this.paths.add(matcher.group(1));
            }
            return true;
        }
    }
}

