/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.config.DataSourcePropertySerializer;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.google.common.base.Preconditions;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import jakarta.annotation.Nonnull;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationBackupStep
extends AbstractMaintenanceTask {
    public static final String BANNER = "#> Produced for backup from datasource configuration";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBackupStep.class);
    private final I18nService i18nService;
    private final BackupState state;
    private final Path sharedHomeDir;
    private volatile int progress;

    public ConfigurationBackupStep(BackupState state, HomeLayout homeLayout, I18nService i18nService) {
        this.i18nService = i18nService;
        this.state = state;
        this.sharedHomeDir = homeLayout.getSharedHomeDir();
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("bitbucket.backup.configuration", new Object[]{Product.NAME}), this.progress);
    }

    public void run() {
        ZipOutputStream stream = this.state.getBackupZipStream();
        Preconditions.checkState((stream != null ? 1 : 0) != 0, (Object)"A backup ZipOutputStream is required");
        try {
            ZipEntry entry = new ZipEntry("bitbucket.properties");
            stream.putNextEntry(entry);
            log.debug("Backing up {} configuration to {}", (Object)Product.NAME, (Object)"bitbucket.properties");
            this.writeConfigurationBackup((OutputStream)new CloseShieldOutputStream((OutputStream)stream));
            stream.closeEntry();
            this.progress = 100;
        }
        catch (IOException e) {
            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.configuration.failed", new Object[]{Product.NAME}), (Throwable)e);
        }
    }

    private boolean containsJdbcProperties(Path config) throws IOException {
        Properties properties = new Properties();
        try (InputStream stream = Files.newInputStream(config, new OpenOption[0]);){
            properties.load(stream);
        }
        return properties.containsKey("jdbc.driver");
    }

    private void writeConfigurationBackup(OutputStream stream) throws IOException {
        Path config = this.sharedHomeDir.resolve("bitbucket.properties");
        boolean exists = Files.exists(config, new LinkOption[0]);
        if (exists) {
            Files.copy(config, stream);
        }
        if (!exists || !this.containsJdbcProperties(config)) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));){
                if (exists) {
                    writer.write("\n");
                }
                this.writeDefaultConfiguration(writer);
            }
        }
    }

    private void writeDefaultConfiguration(BufferedWriter writer) throws IOException {
        DataSourcePropertySerializer serializer = new DataSourcePropertySerializer(this.state.getSourceDatabase().getConfiguration());
        writer.write(BANNER);
        writer.write("\n");
        serializer.writeTo(writer);
    }
}

