/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.maintenance.CompositeMaintenanceTask;
import com.atlassian.stash.internal.maintenance.DrainHelper;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskFactory;
import com.atlassian.stash.internal.maintenance.backup.BackupPhase;
import com.atlassian.stash.internal.maintenance.latch.Latch;
import com.atlassian.stash.internal.maintenance.latch.LatchMode;
import com.atlassian.stash.internal.maintenance.migration.MigrationState;
import com.atlassian.stash.internal.maintenance.migration.SimpleMigrationState;
import com.atlassian.stash.internal.maintenance.restore.RestorePhase;
import com.atlassian.stash.internal.migration.CanceledDatabaseMigrationException;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMigrationTask
implements MaintenanceTask {
    public static final String QUALIFIER_TARGET_DATABASE = "targetDatabase";
    protected static final Logger log = LoggerFactory.getLogger(BaseMigrationTask.class);
    protected final I18nService i18nService;
    protected final MigrationState state;
    protected volatile boolean canceled;
    private final DatabaseManager databaseManager;
    private final MaintenanceTask delegateTask;
    private final int drainTimeoutSeconds;
    private final int forceDrainTimeoutSeconds;

    protected BaseMigrationTask(DatabaseManager databaseManager, MaintenanceTaskFactory factory, I18nService i18nService, DatabaseHandle targetDatabase, int drainTimeoutSeconds, int forceDrainTimeoutSeconds) {
        this.i18nService = i18nService;
        this.databaseManager = databaseManager;
        this.drainTimeoutSeconds = drainTimeoutSeconds;
        this.forceDrainTimeoutSeconds = forceDrainTimeoutSeconds;
        this.state = new SimpleMigrationState(databaseManager.getHandle(), targetDatabase);
        this.delegateTask = this.createMigrationTask(factory, this.state);
    }

    public void cancel() {
        this.canceled = true;
        this.delegateTask.cancel();
    }

    @Nonnull
    public Progress getProgress() {
        return this.delegateTask.getProgress();
    }

    public void run() {
        try {
            this.delegateTask.run();
            if (this.canceled) {
                throw new CanceledDatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.canceled", new Object[0]));
            }
        }
        catch (Throwable t) {
            if (this.canceled) {
                log.info("Reverting database configuration after migration was canceled");
            } else {
                log.error("Reverting database configuration after a failed migration attempt", t);
            }
            this.revert();
            throw Throwables.propagate((Throwable)t);
        }
    }

    protected MaintenanceTask createMigrationTask(MaintenanceTaskFactory factory, MigrationState state) {
        return ((CompositeMaintenanceTask.Builder)((CompositeMaintenanceTask.Builder)((CompositeMaintenanceTask.Builder)new CompositeMaintenanceTask.Builder().add(((BackupPhase.Builder)((BackupPhase.Builder)((BackupPhase.Builder)((BackupPhase.Builder)((BackupPhase.Builder)factory.backupPhaseBuilder(state).add(factory.activeObjectsBackupStep(state), 15)).add(factory.latchAndDrainDatabaseMigrationStep(LatchMode.LOCAL), 5)).add(factory.releaseAffixedDatabaseStep(), 2)).add(factory.databaseBackupStep(state), 75)).add(factory.configurationBackupStep(state), 3)).build(), 18)).add(((RestorePhase.Builder)((RestorePhase.Builder)((RestorePhase.Builder)((RestorePhase.Builder)factory.restorePhaseBuilder(state).add(factory.unpackBackupFilesStep(state), 0)).add(factory.databaseRestoreStep(state), 80)).add(factory.unlatchDatabaseStep(LatchMode.LOCAL, state.getTargetDatabase()), 0)).add(factory.activeObjectsRestoreStep(state), 20)).build(), 82)).add(factory.finalizeMigrationStep(state), 0)).build();
    }

    private void revert() {
        DatabaseLatch latch = (DatabaseLatch)this.databaseManager.getCurrentLatch();
        if (latch == null && !DrainHelper.drain((Latch)(latch = (DatabaseLatch)this.databaseManager.acquireLatch(LatchMode.LOCAL)), this.drainTimeoutSeconds, this.forceDrainTimeoutSeconds)) {
            log.warn("Could not drain all database connections while reverting migration. Switching back to the original database anyway.");
        }
        latch.unlatchTo(this.state.getSourceDatabase());
        this.state.getTargetDatabase().close();
    }
}

