/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.restore;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.stash.internal.backup.BackupDataSourceSupplier;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeSet;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseMigrationDao;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseRestoreMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.restore.RestoreState;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRestoreStep
implements LiquibaseRestoreMonitor,
MaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(DatabaseRestoreStep.class);
    private final BackupDataSourceSupplier backupDataSourceSupplier;
    private final CancelState cancelState;
    private final I18nService i18nService;
    private final LiquibaseMigrationDao migrationDao;
    private final RestoreState state;
    private volatile RestoreProgress progress;

    public DatabaseRestoreStep(RestoreState state, BackupDataSourceSupplier backupDataSourceSupplier, I18nService i18nService, LiquibaseMigrationDao migrationDao) {
        this.backupDataSourceSupplier = backupDataSourceSupplier;
        this.i18nService = i18nService;
        this.migrationDao = migrationDao;
        this.state = state;
        this.cancelState = new SimpleCancelState();
    }

    public void cancel() {
        this.cancelState.cancel(this.i18nService.createKeyedMessage("bitbucket.backup.restore.database.canceled", new Object[]{Product.NAME}));
    }

    @Nonnull
    public Progress getProgress() {
        RestoreProgress progress = this.progress;
        return progress != null ? progress : new ProgressImpl(this.i18nService.getMessage("bitbucket.backup.restore.database", new Object[]{Product.NAME}), 0);
    }

    public void onAppliedChange() {
        RestoreProgress progress = this.progress;
        if (progress == null) {
            throw new IllegalStateException("No current changeset! Must call onBeginChangeset() before calling onAppliedChange().");
        }
        progress.onChange();
    }

    public void onBeginChangeset(LiquibaseChangeSet change, int index, int total) {
        RestoreProgress progress = this.progress;
        this.progress = new RestoreProgress(progress, index, total, change);
    }

    public void onFinishedChangeset() {
    }

    public void run() {
        Path backupDir = this.state.getUnzippedBackupDirectory();
        Preconditions.checkState((backupDir != null ? 1 : 0) != 0, (Object)"Unpacked backup not found");
        this.backupDataSourceSupplier.setDataSource(this.state.getTargetDatabase().getDataSource());
        Path liquibaseFile = backupDir.resolve("stash-data.xml");
        log.debug("Restoring {} data from {}", (Object)Product.NAME, (Object)liquibaseFile);
        try {
            this.migrationDao.restore(liquibaseFile, (LiquibaseRestoreMonitor)this, this.cancelState);
        }
        catch (LiquibaseDataAccessException e) {
            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.restore.fail", new Object[0]), (Throwable)e);
        }
    }

    private class RestoreProgress
    implements Progress {
        private final LiquibaseChangeSet change;
        private final AtomicLong changesCompleted;
        private final int changesetCount;
        private final int changesetIndex;
        private final int previousProgress;

        private RestoreProgress(RestoreProgress previous, int changesetIndex, int changesetCount, LiquibaseChangeSet change) {
            this.change = change;
            this.changesetCount = changesetCount;
            this.changesetIndex = changesetIndex;
            this.previousProgress = previous == null ? 0 : previous.change.getProgress();
            this.changesCompleted = new AtomicLong(0L);
        }

        @Nonnull
        public String getMessage() {
            return DatabaseRestoreStep.this.i18nService.getMessage("bitbucket.restore.changeset.processing", new Object[]{this.changesetIndex, this.changesetCount, this.change.getChangeCount()});
        }

        public int getPercentage() {
            double percentCompleted = (double)this.previousProgress + (double)this.changesCompleted.get() / (double)this.change.getChangeCount() * (double)(this.change.getProgress() - this.previousProgress);
            return Math.min(this.change.getProgress(), (int)Math.ceil(percentCompleted));
        }

        public void onChange() {
            this.changesCompleted.incrementAndGet();
        }
    }
}

