/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.restore;

import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.maintenance.CompositeMaintenanceTask;
import com.atlassian.stash.internal.maintenance.restore.RestoreState;
import jakarta.annotation.Nonnull;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestorePhase
extends CompositeMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(RestorePhase.class);
    private final RestoreState state;

    protected RestorePhase(RestoreState state, CompositeMaintenanceTask.Step[] steps, int totalWeight) {
        super(steps, totalWeight);
        this.state = state;
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            Path unpackedDirectory = this.state.getUnzippedBackupDirectory();
            if (unpackedDirectory != null && Files.exists(unpackedDirectory, new LinkOption[0])) {
                if (MoreFiles.deleteQuietly((Path)unpackedDirectory)) {
                    log.debug("Successfully deleted unpacked files from {}", (Object)unpackedDirectory.toAbsolutePath());
                } else {
                    log.warn("Failed to delete unpacked files at {}; they will need to be deleted manually", (Object)unpackedDirectory.toAbsolutePath());
                }
            }
        }
    }

    public static class Builder
    extends CompositeMaintenanceTask.AbstractBuilder<Builder> {
        private final RestoreState state;

        public Builder(RestoreState state) {
            this.state = state;
        }

        @Override
        @Nonnull
        public RestorePhase build() {
            return new RestorePhase(this.state, this.steps.toArray(new CompositeMaintenanceTask.Step[0]), this.totalWeight);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

