/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.restore;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.migration.MigrationState;
import com.atlassian.stash.internal.migration.DatabaseMigrationException;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpackBackupFilesStep
extends AbstractMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(UnpackBackupFilesStep.class);
    private final HomeLayout homeLayout;
    private final I18nService i18nService;
    private final MigrationState state;
    private volatile int progress;

    public UnpackBackupFilesStep(MigrationState state, HomeLayout homeLayout, I18nService i18nService) {
        this.homeLayout = homeLayout;
        this.i18nService = i18nService;
        this.state = state;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("bitbucket.backup.restore.unpacking.backup", new Object[0]), this.progress);
    }

    public void run() {
        Path backupFile = this.state.getBackupFile();
        Preconditions.checkState((backupFile != null && Files.exists(backupFile, new LinkOption[0]) ? 1 : 0) != 0, (Object)"Backup file not found");
        try {
            this.state.setUnzippedBackupDirectory(this.unpackZip(backupFile));
        }
        catch (IOException e) {
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.backup.restore.unpacking.backup.failed", new Object[]{backupFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path unpackZip(Path zipFile) throws IOException {
        Path directory = Files.createTempDirectory(this.homeLayout.getTempDir(), String.valueOf(zipFile.getFileName()) + "-unpacked", new FileAttribute[0]);
        log.debug("Unpacking backup files to {}", (Object)directory.toAbsolutePath());
        ZipFile zip = new ZipFile(zipFile.toFile());
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                if (this.isCanceled()) {
                    log.debug("Canceled while unpacking backup files");
                    Path path = directory;
                    return path;
                }
                ZipEntry entry = entries.nextElement();
                Path file = directory.resolve(entry.getName());
                log.debug("Unpacking {} ({} bytes) to {}", new Object[]{entry.getName(), entry.getSize(), file.toAbsolutePath()});
                long bytes = Files.copy(zip.getInputStream(entry), file, new CopyOption[0]);
                if (bytes == entry.getSize()) continue;
                log.warn("{} may not have been completely extracted; unpacked {} bytes where {} were expected", new Object[]{entry.getName(), bytes, entry.getSize()});
            }
            log.debug("All backup files have been unpacked");
        }
        finally {
            this.progress = 100;
            try {
                zip.close();
            }
            catch (IOException e) {
                log.warn("Failed to close backup file {}", (Object)zipFile.toAbsolutePath(), (Object)e);
            }
        }
        return directory;
    }
}

