/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.markup;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkShuttingDownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.markup.MarkupFactory;
import com.atlassian.stash.internal.markup.MarkupFileParser;
import com.atlassian.stash.internal.markup.MarkupParser;
import com.atlassian.stash.internal.markup.parser.HtmlSanitizerParserFactory;
import com.atlassian.stash.internal.markup.parser.TextParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=MarkupFactory.class)
@Component
public class MarkupFactoryImpl
implements MarkupFactory,
ServiceTrackerCustomizer<MarkupFileParser, MarkupFileParser> {
    private static final MarkupParser TEXT_PARSER = new TextParser();
    private static final Logger log = LoggerFactory.getLogger(MarkupFactoryImpl.class);
    private final OsgiContainerManager containerManager;
    private final HtmlSanitizerParserFactory htmlSanitizerParserFactory;
    private final Map<String, MarkupParser> parsers = new ConcurrentHashMap<String, MarkupParser>();
    private BundleContext bundleContext;
    private ServiceTracker<MarkupFileParser, MarkupFileParser> serviceTracker;

    @Autowired
    public MarkupFactoryImpl(HtmlSanitizerParserFactory htmlSanitizerParserFactory, OsgiContainerManager containerManager) {
        this.htmlSanitizerParserFactory = htmlSanitizerParserFactory;
        this.containerManager = containerManager;
    }

    public MarkupFileParser addingService(ServiceReference<MarkupFileParser> serviceReference) {
        MarkupFileParser parser = (MarkupFileParser)this.bundleContext.getService(serviceReference);
        if (parser == null) {
            log.debug("Failed to resolve MarkupFileParser from bundle {} for reference {}", (Object)serviceReference.getBundle(), serviceReference);
            return null;
        }
        for (String ext : parser.getExtensions()) {
            String key = ext.toLowerCase(Locale.ROOT);
            MarkupParser existingParser = this.parsers.get(key);
            if (existingParser == null) {
                this.parsers.put(key, parser);
                continue;
            }
            log.warn("A parser is already registered for extension {}. Ignoring new parser. Existing parser: {}   New parser: {}", new Object[]{key, existingParser.getClass().getName(), parser.getClass().getName()});
        }
        return parser;
    }

    @Override
    @Nonnull
    public MarkupParser getParser(@Nonnull String filename) {
        MarkupParser parser = this.getParserUnsafe(filename);
        return parser != null ? parser : TEXT_PARSER;
    }

    @Override
    @Nullable
    public MarkupParser getParserUnsafe(@Nonnull String filename) {
        MarkupParser parser = this.parsers.get(FilenameUtils.getExtension((String)filename).toLowerCase(Locale.ROOT));
        return parser != null ? this.htmlSanitizerParserFactory.createParser(parser) : null;
    }

    public void modifiedService(ServiceReference<MarkupFileParser> reference, MarkupFileParser service) {
    }

    @EventListener
    public void onPluginFrameworkShuttingDown(PluginFrameworkShuttingDownEvent event) {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
        }
        this.parsers.clear();
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.bundleContext = this.containerManager.getBundles()[0].getBundleContext();
        this.serviceTracker = new ServiceTracker(this.bundleContext, MarkupFileParser.class, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public void removedService(ServiceReference<MarkupFileParser> reference, MarkupFileParser service) {
        this.bundleContext.ungetService(reference);
        for (String ext : service.getExtensions()) {
            String key = ext.toLowerCase(Locale.ROOT);
            MarkupParser parser = this.parsers.get(key);
            if (!service.equals(parser)) continue;
            this.parsers.remove(key);
        }
    }
}

