/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.markup.parser;

import com.atlassian.bitbucket.internal.suggestion.parser.SuggestionIndexingExtension;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.markup.MarkupFileParser;
import com.atlassian.stash.internal.markup.MarkupOptions;
import com.atlassian.stash.internal.markup.MarkupParser;
import com.atlassian.stash.internal.markup.parser.TextParser;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.heading.anchor.HeadingAnchorExtension;
import org.commonmark.ext.image.attributes.ImageAttributesExtension;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.AttributeProvider;
import org.commonmark.renderer.html.DefaultUrlSanitizer;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.html.UrlSanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=MarkupFileParser.class)
@Component(value="commonMarkParser")
public class CommonMarkParser
implements MarkupFileParser {
    private static final Logger log = LoggerFactory.getLogger(CommonMarkParser.class);
    private static final String ALLOWABLE_ID_PREFIX = "user-content-";
    private static final AttributeProvider CODE_BLOCK_ATTRIBUTE_PROVIDER = new DataCodeBlockAttributeProvider();
    private static final MarkupOptions DEFAULT_OPTIONS = MarkupOptions.builder().hardwrap(false).build();
    private static final Extension EXTENSION_AUTOLINK = AutolinkExtension.create();
    private static final Extension EXTENSION_IMAGE_ATTRIBUTES = ImageAttributesExtension.create();
    private static final Extension EXTENSION_STRIKETHROUGH = StrikethroughExtension.builder().requireTwoTildes(true).build();
    private static final Extension EXTENSION_SUGGESTION_INDEX = SuggestionIndexingExtension.create();
    private static final Extension EXTENSION_TABLES = TablesExtension.create();
    private static final List<? extends Extension> EXTENSIONS = Arrays.asList(EXTENSION_AUTOLINK, EXTENSION_IMAGE_ATTRIBUTES, EXTENSION_STRIKETHROUGH, EXTENSION_SUGGESTION_INDEX, EXTENSION_TABLES);
    private static final List<? extends Extension> EXTENSIONS_WITH_ANCHOR = Arrays.asList(EXTENSION_AUTOLINK, EXTENSION_IMAGE_ATTRIBUTES, EXTENSION_STRIKETHROUGH, EXTENSION_SUGGESTION_INDEX, EXTENSION_TABLES, HeadingAnchorExtension.builder().idPrefix("user-content-").build());
    private static final List<String> FILE_EXTENSIONS = ImmutableList.of((Object)"md", (Object)"markdown", (Object)"mdown", (Object)"mkdn", (Object)"mkd");
    private static final Parser PARSER = Parser.builder().extensions(EXTENSIONS).build();
    private static final MarkupParser TEXT_PARSER = new TextParser();
    private final Set<String> allowedProtocols;

    public CommonMarkParser(@Value(value="${markup.render.url.protocols}") String allowedProtocols) {
        this.allowedProtocols = (Set)MoreStreams.streamIterable((Iterable)Splitter.on((String)",").split((CharSequence)allowedProtocols)).map(StringUtils::trimToNull).filter(Objects::nonNull).map(protocol -> protocol.toLowerCase(Locale.US)).collect(MoreCollectors.toImmutableSet());
    }

    @Override
    @Nonnull
    public List<String> getExtensions() {
        return FILE_EXTENSIONS;
    }

    @Override
    @Nonnull
    public String markup(@Nonnull String markdownText) {
        return this.markup(markdownText, DEFAULT_OPTIONS);
    }

    @Override
    @Nonnull
    public String markup(@Nonnull String markdownText, @Nonnull MarkupOptions options) {
        HtmlRenderer renderer = HtmlRenderer.builder().escapeHtml(options.isHtmlEscaped()).softbreak(options.isHardwrap() ? "<br />" : "\n").attributeProviderFactory(context -> CODE_BLOCK_ATTRIBUTE_PROVIDER).extensions(options.isIdAddedToHeaders() ? EXTENSIONS_WITH_ANCHOR : EXTENSIONS).sanitizeUrls(true).urlSanitizer((UrlSanitizer)new DefaultUrlSanitizer(this.allowedProtocols)).build();
        try {
            Node node = PARSER.parse(markdownText);
            return renderer.render(node);
        }
        catch (RuntimeException | StackOverflowError e) {
            if (log.isDebugEnabled()) {
                log.debug("Error parsing commonmark + " + markdownText, e);
            }
            return TEXT_PARSER.markup(markdownText);
        }
    }

    private static class DataCodeBlockAttributeProvider
    implements AttributeProvider {
        private DataCodeBlockAttributeProvider() {
        }

        public void setAttributes(Node node, String tagName, Map<String, String> attributes) {
            if (node instanceof FencedCodeBlock && "code".equals(tagName)) {
                FencedCodeBlock codeBlock = (FencedCodeBlock)node;
                attributes.remove("class");
                String info = codeBlock.getInfo();
                if (!StringUtils.isBlank((CharSequence)info)) {
                    attributes.put("data-language", codeBlock.getInfo());
                }
            }
        }
    }
}

