/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.markup.parser;

import com.atlassian.stash.internal.markup.MarkupOptions;
import com.atlassian.stash.internal.markup.MarkupParser;
import com.atlassian.stash.internal.markup.parser.TextParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.regex.Pattern;
import org.owasp.html.AttributePolicy;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.PolicyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HtmlSanitizerParserFactory {
    private static final MarkupParser TEXT_PARSER = new TextParser();
    private static final Logger log = LoggerFactory.getLogger(HtmlSanitizerParserFactory.class);

    public MarkupParser createParser(MarkupParser delegate) {
        return new HtmlSanitizerMarkupParser(delegate);
    }

    private static class HtmlSanitizerMarkupParser
    implements MarkupParser {
        private final MarkupParser delegate;

        public HtmlSanitizerMarkupParser(MarkupParser delegate) {
            this.delegate = delegate;
        }

        @Override
        @Nonnull
        public String markup(@Nonnull String markup) {
            return this.clean(markup, this.delegate.markup(markup));
        }

        @Override
        @Nonnull
        public String markup(@Nonnull String markup, @Nonnull MarkupOptions options) {
            return this.clean(markup, this.delegate.markup(markup, options));
        }

        private String clean(String original, String markup) {
            try {
                StringBuilder output = new StringBuilder();
                HtmlStreamRenderer renderer = HtmlStreamRenderer.create((StringBuilder)output, errorMessage -> {
                    throw new IllegalArgumentException((String)errorMessage);
                });
                HtmlSanitizer.sanitize((String)markup, (HtmlSanitizer.Policy)BitbucketPolicy.POLICY_DEFINITION.apply((HtmlStreamEventReceiver)renderer));
                return output.toString();
            }
            catch (Exception e) {
                log.debug("Failed to scan the following piece of HTML, returning default sanitized version of it:\n{}", (Object)markup, (Object)e);
                return TEXT_PARSER.markup(original);
            }
        }
    }

    private static class BitbucketPolicy {
        private static final AttributePolicy CLASS_POLICY = new AttributePolicy(){
            final Pattern MENTION_PATTERN = Pattern.compile("(?:user-mention(?:| | current-user))");

            @Nullable
            public String apply(@Nonnull String elementName, @Nonnull String attributeName, @Nonnull String value) {
                if ("table".equalsIgnoreCase(elementName) && "aui".equalsIgnoreCase(value)) {
                    return value;
                }
                return this.MENTION_PATTERN.matcher(value).matches() ? value : null;
            }
        };
        private static final Pattern HTML_COLOR_ATTR = Pattern.compile("((aqua|black|blue|fuchsia|gray|grey|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow)|#[0-9a-fA-F]{8}|#[0-9a-fA-F]{6}|#[0-9a-fA-F]{3,4})");
        private static final Pattern HTML_ID = Pattern.compile("[\\p{L}\\p{N}\\p{M}\\w\\:\\-_\\.]+");
        private static final Pattern NAME = Pattern.compile("[a-zA-Z0-9\\-_\\$]+");
        private static final Pattern NUMBER = Pattern.compile("[+-]?(?:(?:[0-9]+(?:\\.[0-9]*)?)|\\.[0-9]+)");
        private static final Pattern HTML_ID_USER_CONTENT = Pattern.compile("user-content-[\\p{L}\\p{N}\\p{M}\\w\\:\\-_\\.]+");
        private static final Pattern WIDTH_OR_HEIGHT = Pattern.compile("(\\d)+(%|px)?");
        private static final PolicyFactory POLICY_DEFINITION = new HtmlPolicyBuilder().allowCommonBlockElements().allowCommonInlineFormattingElements().allowElements(new String[]{"a", "br", "center", "cite", "col", "dd", "del", "dl", "dt", "fieldset", "hr", "img", "ins", "label", "legend", "pre", "samp", "table", "tr", "td", "th", "colgroup", "caption", "col", "thead", "tbody", "tfoot"}).allowWithoutAttributes(new String[]{"span", "p", "code", "font"}).allowStandardUrlProtocols().allowUrlProtocols(new String[]{"callto", "cvs", "facetime", "feed", "ftp", "ftps", "git", "hipchat", "irc", "irc6", "itms", "mvn", "news", "nntp", "notes", "skype", "smb", "sourcetree", "ssh", "svn", "tel", "urn"}).allowAttributes(new String[]{"abbr"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"align"}).matching(true, new String[]{"center", "middle", "left", "right", "justify", "char"}).onElements(new String[]{"p", "div", "img", "thead", "tbody", "tfoot", "table", "td", "th", "tr", "colgroup", "col"}).allowAttributes(new String[]{"align", "valign"}).onElements(new String[]{"table", "tr", "td", "th", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"axis"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"background"}).onElements(new String[]{"table", "tr", "td"}).allowAttributes(new String[]{"bgcolor"}).matching(HTML_COLOR_ATTR).onElements(new String[]{"table", "td", "th"}).allowAttributes(new String[]{"border"}).matching(NUMBER).onElements(new String[]{"img", "table"}).allowAttributes(new String[]{"border", "hspace", "vspace"}).matching(NUMBER).onElements(new String[]{"img"}).allowAttributes(new String[]{"cellpadding", "cellspacing"}).matching(NUMBER).onElements(new String[]{"table"}).allowAttributes(new String[]{"class"}).matching(CLASS_POLICY).globally().allowAttributes(new String[]{"color"}).matching(HTML_COLOR_ATTR).onElements(new String[]{"font"}).allowAttributes(new String[]{"colspan", "rowspan"}).matching(NUMBER).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"data-atlassian-layout"}).globally().allowAttributes(new String[]{"data-color"}).matching(HTML_COLOR_ATTR).onElements(new String[]{"span"}).allowAttributes(new String[]{"data-highlight-class"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"data-inline-task-id"}).matching(NUMBER).onElements(new String[]{"li", "dt", "dd"}).allowAttributes(new String[]{"data-language"}).matching(NAME).globally().allowAttributes(new String[]{"data-suggestion-index"}).matching(NUMBER).globally().allowAttributes(new String[]{"face"}).matching(Pattern.compile("[\\w;, \\-]+")).onElements(new String[]{"font"}).allowAttributes(new String[]{"for"}).matching(HTML_ID).onElements(new String[]{"label"}).allowAttributes(new String[]{"headers"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"height"}).matching(WIDTH_OR_HEIGHT).onElements(new String[]{"img", "table", "tr", "td", "th"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"id"}).matching(HTML_ID_USER_CONTENT).globally().allowAttributes(new String[]{"lang"}).matching(Pattern.compile("[a-zA-Z]{2,20}")).globally().allowAttributes(new String[]{"name"}).onElements(new String[]{"a", "img"}).allowAttributes(new String[]{"nohref"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"noresize"}).matching(true, new String[]{"noresize"}).onElements(new String[]{"table"}).allowAttributes(new String[]{"nowrap"}).matching(true, new String[]{"nowrap"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"rel"}).matching(true, new String[]{"nofollow"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"scope"}).matching(true, new String[]{"row", "col", "rowgroup", "colgroup"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"size"}).matching(Pattern.compile("[+\\-]?\\d+")).onElements(new String[]{"font"}).allowAttributes(new String[]{"span"}).matching(NUMBER).onElements(new String[]{"colgroup", "col"}).allowAttributes(new String[]{"src", "alt"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"start"}).matching(NUMBER).onElements(new String[]{"ol"}).allowAttributes(new String[]{"summary"}).onElements(new String[]{"table"}).allowAttributes(new String[]{"title"}).globally().allowAttributes(new String[]{"width"}).matching(WIDTH_OR_HEIGHT).onElements(new String[]{"img", "table", "tr", "td", "th", "colgroup", "col"}).toFactory();

        private BitbucketPolicy() {
        }
    }
}

