/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.markup.parser;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.markup.MarkupFileParser;
import com.atlassian.stash.internal.markup.MarkupOptions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=MarkupFileParser.class)
@Component(value="textParser")
public class TextParser
implements MarkupFileParser {
    private static final ImmutableList<String> FILE_EXTENSIONS = ImmutableList.of((Object)"txt", (Object)"text");

    @Override
    @Nonnull
    public List<String> getExtensions() {
        return FILE_EXTENSIONS;
    }

    @Override
    @Nonnull
    public String markup(@Nonnull String markup) {
        return "<pre>" + StringEscapeUtils.escapeHtml4((String)markup) + "</pre>";
    }

    @Override
    @Nonnull
    public String markup(@Nonnull String markup, @Nonnull MarkupOptions options) {
        return this.markup(markup);
    }
}

