/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.markup.renderer;

import com.atlassian.bitbucket.dmz.markup.renderer.MarkupRendererComponentModuleDescriptor;
import com.atlassian.bitbucket.dmz.markup.renderer.RenderContext;
import com.atlassian.bitbucket.dmz.markup.renderer.RenderTransform;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.markup.renderer.MarkupRenderer;
import com.atlassian.stash.internal.markup.renderer.TokenReplacer;
import com.atlassian.stash.internal.markup.renderer.TransformUtils;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupRendererImpl
implements MarkupRenderer {
    private static final Logger log = LoggerFactory.getLogger(MarkupRendererImpl.class);
    private final PluginAccessor pluginAccessor;
    private final Function<? super CharSequence, ? extends CharSequence> transform;

    public MarkupRendererImpl(PluginAccessor pluginAccessor, Function<? super CharSequence, ? extends CharSequence> transform) {
        this.pluginAccessor = pluginAccessor;
        this.transform = transform;
    }

    @Override
    public Reader render(Reader content, RenderContext context) throws IOException {
        TokenReplacer tokenReplacer = this.renderReplace(content, context);
        CharSequence markup = this.transform.apply(tokenReplacer.getIntermediate());
        return new CharSequenceReader(tokenReplacer.resolve(markup));
    }

    private TokenReplacer renderReplace(Reader content, RenderContext context) throws IOException {
        List<MarkupRendererComponentModuleDescriptor> handlers = this.pluginAccessor.getEnabledModuleDescriptorsByClass(MarkupRendererComponentModuleDescriptor.class).stream().sorted().collect(Collectors.toList());
        String input = IOUtils.toString((Reader)content);
        if (!handlers.isEmpty()) {
            return MarkupRendererImpl.transform(input, context, handlers);
        }
        return new TokenReplacer(input, Function.identity());
    }

    protected static TokenReplacer transform(CharSequence input, RenderContext context, Iterable<MarkupRendererComponentModuleDescriptor> modules) {
        return TransformUtils.tokenReplace(input, Iterables.transform(modules, descriptor -> {
            try {
                return descriptor.getModule().process(input, context);
            }
            catch (Exception e) {
                log.warn("{} failed to transform markup due to an unexpected exception. Skipping transformation.", (Object)descriptor.getCompleteKey(), (Object)e);
                return RenderTransform.builder().build();
            }
        }));
    }
}

