/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.markup.renderer;

import com.atlassian.bitbucket.dmz.markup.renderer.RenderTransform;
import com.atlassian.bitbucket.dmz.markup.renderer.Replacement;
import com.atlassian.stash.internal.markup.renderer.TokenReplacer;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TransformUtils {
    private static final Predicate<Replacement> IS_NOT_IMMEDIATE = input -> !input.isImmediate();
    private static final Ordering<Replacement> REPLACEMENT_ORDERING = Ordering.from(Comparator.comparingInt(Replacement::getStart));
    private static final String TOKEN_CONSTANT = "\ufffc";
    private static final Pattern TOKEN_CONSTANT_PATTERN = Pattern.compile("\\x{FFFC}|&#xfffc;");

    public static TokenReplacer tokenReplace(CharSequence input, Iterable<RenderTransform> transforms) {
        List<Replacement> all = TransformUtils.getReplacements(transforms);
        ArrayList original = Lists.newArrayList((Iterable)Iterables.filter(all, IS_NOT_IMMEDIATE));
        List replacements = Lists.transform(all, r -> !r.isImmediate() ? r.setValue((CharSequence)TOKEN_CONSTANT) : r);
        return new TokenReplacer(TransformUtils.replace(input, replacements), input1 -> {
            StringBuffer b = new StringBuffer();
            Matcher matcher = TOKEN_CONSTANT_PATTERN.matcher(input1.toString());
            int i = 0;
            while (matcher.find()) {
                if (i < original.size()) {
                    matcher.appendReplacement(b, Matcher.quoteReplacement(((Replacement)original.get(i)).getValue().toString()));
                } else {
                    matcher.appendReplacement(b, "");
                }
                ++i;
            }
            matcher.appendTail(b);
            return b;
        });
    }

    private static List<Replacement> getReplacements(Iterable<RenderTransform> transforms) {
        return TransformUtils.removeOverlappingReplacements(REPLACEMENT_ORDERING.sortedCopy(Iterables.concat((Iterable)Iterables.transform(transforms, RenderTransform::getReplacements))));
    }

    private static List<Replacement> removeOverlappingReplacements(List<Replacement> replacements) {
        int i = 0;
        ImmutableList.Builder newReplacements = ImmutableList.builder();
        for (Replacement replacement : replacements) {
            if (replacement.getStart() < i) continue;
            newReplacements.add((Object)replacement);
            i = replacement.getEnd();
        }
        return newReplacements.build();
    }

    private static CharSequence replace(CharSequence input, List<Replacement> replacements) {
        if (replacements.isEmpty()) {
            return input;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (Replacement replacement : replacements) {
            b.append(input.subSequence(i, replacement.getStart()));
            CharSequence value = replacement.getValue();
            b.append(value);
            i = replacement.getEnd();
        }
        b.append(input.subSequence(i, input.length()));
        return b.toString();
    }
}

