/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.PluginMergeStrategy;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.merge.InternalAbstractMergeConfig;
import com.atlassian.stash.internal.merge.InternalProjectMergeConfig;
import com.atlassian.stash.internal.merge.InternalRepositoryMergeConfig;
import com.atlassian.stash.internal.merge.InternalScmMergeConfig;
import com.atlassian.stash.internal.merge.MergeConfig;
import com.atlassian.stash.internal.merge.MergeConfigHelper;
import com.atlassian.stash.internal.merge.MergeConfigType;
import com.atlassian.stash.internal.merge.ProjectMergeConfigDao;
import com.atlassian.stash.internal.merge.RepositoryMergeConfigDao;
import com.atlassian.stash.internal.merge.ScmMergeConfigDao;
import com.atlassian.stash.internal.merge.SimpleMergeConfig;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="mergeConfigHelper")
@Profiled
public class DefaultMergeConfigHelper
implements MergeConfigHelper {
    private final I18nService i18nService;
    private final ProjectMergeConfigDao projectConfigDao;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final RepositoryMergeConfigDao repositoryConfigDao;
    private final ScmMergeConfigDao scmConfigDao;
    private final InternalScmService scmService;

    @Autowired
    public DefaultMergeConfigHelper(I18nService i18nService, ProjectMergeConfigDao projectConfigDao, DmzProjectSettingsRestrictionService projectSettingsRestrictionService, RepositoryMergeConfigDao repositoryConfigDao, ScmMergeConfigDao scmConfigDao, InternalScmService scmService) {
        this.i18nService = i18nService;
        this.projectConfigDao = projectConfigDao;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.repositoryConfigDao = repositoryConfigDao;
        this.scmConfigDao = scmConfigDao;
        this.scmService = scmService;
    }

    @Override
    public void deleteForProjectAndScm(@Nonnull Project project, @Nonnull String scmId) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(scmId, "scmId");
        this.projectConfigDao.deleteByProjectAndScm(project.getId(), scmId);
    }

    @Override
    public void deleteForRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        if (this.projectSettingsRestrictionService.hasRestriction(repository.getProject(), ProjectSettingsRestrictionKeys.MERGE_STRATEGIES)) {
            throw new ForbiddenException(this.i18nService.createKeyedMessage("bitbucket.config.mergestrategies.restrictionexists.revoke", new Object[0]));
        }
        this.repositoryConfigDao.deleteByRepository(repository.getId());
    }

    @Override
    public void deleteForScm(@Nonnull String scmId) {
        Objects.requireNonNull(scmId, "scmId");
        this.scmConfigDao.deleteByScm(scmId);
    }

    @Override
    @Nonnull
    public MergeConfig getForProjectAndScm(@Nonnull Project project, @Nonnull String scmId) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(scmId, "scmId");
        InternalProjectMergeConfig config = this.projectConfigDao.findByProjectAndScm(project.getId(), scmId);
        if (config == null) {
            return this.getForScm(scmId);
        }
        return this.toMergeConfig(scmId, (InternalAbstractMergeConfig)config);
    }

    @Override
    @Nonnull
    public MergeConfig getForRepository(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        if (this.projectSettingsRestrictionService.hasRestriction(repository.getProject(), ProjectSettingsRestrictionKeys.MERGE_STRATEGIES)) {
            return this.getForProjectAndScm(repository.getProject(), repository.getScmId());
        }
        InternalRepositoryMergeConfig config = this.repositoryConfigDao.findByRepository(repository.getId());
        if (config == null) {
            return this.getForProjectAndScm(repository.getProject(), repository.getScmId());
        }
        return this.toMergeConfig(repository.getScmId(), (InternalAbstractMergeConfig)config);
    }

    @Override
    @Nonnull
    public MergeConfig getForScm(@Nonnull String scmId) {
        Objects.requireNonNull(scmId, "scmId");
        return this.toMergeConfig(scmId, (InternalAbstractMergeConfig)this.scmConfigDao.findByScm(scmId));
    }

    @Override
    public void setForProjectAndScm(@Nonnull Project project, @Nonnull String scmId, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> strategyIds, @Nullable PullRequestCommitMessageTemplate commitMessageTemplate, boolean shouldUpdateCommitMessageTemplate) {
        Objects.requireNonNull(project, "project");
        this.validateStrategies(scmId, defaultStrategyId, strategyIds);
        this.validateCommitMessageTemplate(commitMessageTemplate);
        InternalProjectMergeConfig config = this.projectConfigDao.findByProjectAndScm(project.getId(), scmId);
        if (config == null) {
            this.projectConfigDao.create((Object)new InternalProjectMergeConfig(InternalConverter.convertToInternalProject((Project)project), scmId, commitSummaries, defaultStrategyId, strategyIds, commitMessageTemplate));
        } else {
            config.setCommitSummaries(commitSummaries);
            config.setDefaultStrategyId(defaultStrategyId);
            config.setStrategyIds(strategyIds);
            if (shouldUpdateCommitMessageTemplate) {
                config.setCommitMessageTemplate(commitMessageTemplate);
            }
            this.projectConfigDao.update((Object)config);
        }
    }

    @Override
    public void setForRepository(@Nonnull Repository repository, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> strategyIds, @Nullable PullRequestCommitMessageTemplate commitMessageTemplate, boolean shouldUpdateCommitMessageTemplate) {
        this.validateStrategies(Objects.requireNonNull(repository, "repository").getScmId(), defaultStrategyId, strategyIds);
        this.validateCommitMessageTemplate(commitMessageTemplate);
        if (this.projectSettingsRestrictionService.hasRestriction(repository.getProject(), ProjectSettingsRestrictionKeys.MERGE_STRATEGIES)) {
            throw new ForbiddenException(this.i18nService.createKeyedMessage("bitbucket.config.mergestrategies.restrictionexists.set", new Object[0]));
        }
        InternalRepositoryMergeConfig config = this.repositoryConfigDao.findByRepository(repository.getId());
        if (config == null) {
            this.repositoryConfigDao.create((Object)new InternalRepositoryMergeConfig(InternalConverter.convertToInternalRepository((Repository)repository), commitSummaries, defaultStrategyId, strategyIds, commitMessageTemplate));
        } else {
            config.setCommitSummaries(commitSummaries);
            config.setDefaultStrategyId(defaultStrategyId);
            config.setStrategyIds(strategyIds);
            if (shouldUpdateCommitMessageTemplate) {
                config.setCommitMessageTemplate(commitMessageTemplate);
            }
            this.repositoryConfigDao.update((Object)config);
        }
    }

    @Override
    public void setForScm(@Nonnull String scmId, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> strategyIds) {
        this.validateStrategies(scmId, defaultStrategyId, strategyIds);
        InternalScmMergeConfig config = this.scmConfigDao.findByScm(scmId);
        if (config == null) {
            this.scmConfigDao.create((Object)new InternalScmMergeConfig(scmId, commitSummaries, defaultStrategyId, strategyIds));
        } else {
            config.setCommitSummaries(commitSummaries);
            config.setDefaultStrategyId(defaultStrategyId);
            config.setStrategyIds(strategyIds);
            this.scmConfigDao.update((Object)config);
        }
    }

    private static List<String> sort(Set<String> ids) {
        return ids.stream().sorted().collect(Collectors.toList());
    }

    private MergeConfig toMergeConfig(@Nonnull String scmId, @Nullable InternalAbstractMergeConfig config) {
        PullRequestCommitMessageTemplate commitMessageTemplate;
        MergeConfigType type;
        String defaultStrategyId;
        int commitSummaries;
        Set availableStrategies = this.scmService.getMergeStrategies(scmId).getStrategies();
        HashSet<String> enabledStrategyIds = new HashSet<String>();
        if (config == null) {
            commitSummaries = 20;
            defaultStrategyId = null;
            type = MergeConfigType.DEFAULT;
            commitMessageTemplate = null;
        } else {
            commitSummaries = config.getCommitSummaries();
            type = config.getType();
            enabledStrategyIds.addAll(config.getStrategyIds());
            enabledStrategyIds.retainAll(availableStrategies.stream().map(PluginMergeStrategy::getId).collect(Collectors.toSet()));
            defaultStrategyId = enabledStrategyIds.contains(config.getDefaultStrategyId()) ? config.getDefaultStrategyId() : (String)enabledStrategyIds.stream().sorted().findFirst().orElse(null);
            commitMessageTemplate = config.getCommitMessageTemplate();
        }
        if (defaultStrategyId == null) {
            PluginMergeStrategy defaultStrategy = availableStrategies.stream().filter(PluginMergeStrategy::isDefault).findFirst().orElseGet(() -> (PluginMergeStrategy)Iterables.getFirst((Iterable)availableStrategies, null));
            defaultStrategyId = defaultStrategy.getId();
        }
        enabledStrategyIds.add(defaultStrategyId);
        return new SimpleMergeConfig(availableStrategies, commitSummaries, defaultStrategyId, enabledStrategyIds, type, commitMessageTemplate);
    }

    private void validateCommitMessageTemplate(PullRequestCommitMessageTemplate template) {
        if (template == null) {
            return;
        }
        if (template.getTitle().trim().isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.invalid.commitmessagetemplate.titlemissing", new Object[0]));
        }
        if (template.getTitle().length() > 255) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.invalid.commitmessagetemplate.titletoolong", new Object[]{255}));
        }
        if (template.getBody().length() > 5000) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.mergeconfig.invalid.commitmessagetemplate.bodytoolong", new Object[]{5000}));
        }
    }

    private void validateStrategies(@Nonnull String scmId, @Nonnull String defaultStrategyId, @Nonnull Set<String> strategyIds) {
        Objects.requireNonNull(scmId, "scmId");
        Objects.requireNonNull(defaultStrategyId, "defaultStrategyId");
        Objects.requireNonNull(strategyIds, "strategyIds");
        if (strategyIds.contains(defaultStrategyId)) {
            Set<String> supportedIds = this.scmService.getMergeStrategies(scmId).getStrategies().stream().map(PluginMergeStrategy::getId).collect(Collectors.toSet());
            if (!supportedIds.containsAll(strategyIds)) {
                Sets.SetView unsupportedIds = Sets.difference(strategyIds, supportedIds);
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.config.mergestrategies.unsupported", new Object[]{DefaultMergeConfigHelper.sort((Set<String>)unsupportedIds), unsupportedIds.size(), DefaultMergeConfigHelper.sort(supportedIds), supportedIds.size(), scmId}));
            }
        } else {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.config.mergestrategies.defaultnotenabled", new Object[]{defaultStrategyId, DefaultMergeConfigHelper.sort(strategyIds), strategyIds.size()}));
        }
    }
}

