/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge;

import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.scm.PluginMergeStrategy;
import com.atlassian.stash.internal.merge.MergeConfig;
import com.atlassian.stash.internal.merge.MergeConfigType;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SimpleMergeConfig
implements MergeConfig {
    private final Set<PluginMergeStrategy> availableStrategies;
    private final PullRequestCommitMessageTemplate commitMessageTemplate;
    private final int commitSummaries;
    private final String defaultStrategyId;
    private final Set<String> enabledStrategyIds;
    private final MergeConfigType type;

    public SimpleMergeConfig(@Nonnull Set<PluginMergeStrategy> availableStrategies, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> enabledStrategyIds, @Nonnull MergeConfigType type, @Nullable PullRequestCommitMessageTemplate commitMessageTemplate) {
        this.availableStrategies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(availableStrategies, "availableStrategies"));
        this.commitSummaries = commitSummaries;
        this.defaultStrategyId = Objects.requireNonNull(defaultStrategyId, "defaultStrategyId");
        this.enabledStrategyIds = ImmutableSet.copyOf((Collection)Objects.requireNonNull(enabledStrategyIds, "enabledStrategyIds"));
        this.type = Objects.requireNonNull(type, "type");
        this.commitMessageTemplate = commitMessageTemplate;
    }

    @Override
    @Nonnull
    public Set<PluginMergeStrategy> getAvailableStrategies() {
        return this.availableStrategies;
    }

    @Override
    @Nonnull
    public Optional<PullRequestCommitMessageTemplate> getCommitMessageTemplate() {
        return Optional.ofNullable(this.commitMessageTemplate);
    }

    @Override
    public int getCommitSummaries() {
        return this.commitSummaries;
    }

    @Override
    @Nonnull
    public String getDefaultStrategyId() {
        return this.defaultStrategyId;
    }

    @Override
    @Nonnull
    public Set<String> getEnabledStrategyIds() {
        return this.enabledStrategyIds;
    }

    @Override
    @Nonnull
    public MergeConfigType getType() {
        return this.type;
    }

    @Override
    public boolean isAvailable(@Nonnull String strategyId) {
        Objects.requireNonNull(strategyId, "strategyId");
        return this.availableStrategies.stream().map(PluginMergeStrategy::getId).anyMatch(strategyId::equals);
    }

    @Override
    public boolean isEnabled(@Nonnull String strategyId) {
        return this.enabledStrategyIds.contains(Objects.requireNonNull(strategyId, "strategyId"));
    }
}

