/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge.upgrade;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.DeprecateConfigurationRequest;
import com.atlassian.stash.internal.merge.InternalProjectMergeConfig;
import com.atlassian.stash.internal.merge.InternalRepositoryMergeConfig;
import com.atlassian.stash.internal.merge.InternalScmMergeConfig;
import com.atlassian.stash.internal.merge.ProjectMergeConfigDao;
import com.atlassian.stash.internal.merge.RepositoryMergeConfigDao;
import com.atlassian.stash.internal.merge.ScmMergeConfigDao;
import com.atlassian.stash.internal.spring.env.PropertySourceUtils;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import com.atlassian.stash.internal.util.TransactionBatcher;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component(value="migrateMergeConfigUpgradeTask")
@UpgradeTask(value="core-merge-strategies")
public class MigrateMergeConfigUpgradeTask
implements EnvironmentAware {
    static final String DEPRECATION_MESSAGE = "Pull request merge configuration using bitbucket.properties has been deprecated. Your settings have been migrated to the database. REST configuration for SCM and project level is now available. Repositories can be configured both via REST and the UI.";
    static final String KEY_TASK = "core-merge-strategies";
    static final String KEY_TASK_LOCK = "core-merge-strategies.lock";
    static final String SCM_ID = "git";
    private static final String MERGE_STRATEGY_KEY = "plugin.bitbucket-git.pullrequest.merge.strategy";
    private static final Set<String> VALID_STRATEGY_IDS = ImmutableSet.of((Object)"ff", (Object)"ff-only", (Object)"no-ff", (Object)"squash", (Object)"squash-ff-only");
    private static final Logger log = LoggerFactory.getLogger(MigrateMergeConfigUpgradeTask.class);
    private final ConfigurationService configurationService;
    private final HomeLayout homeLayout;
    private final LockService lockService;
    private final ProjectMergeConfigDao projectMergeConfigDao;
    private final ProjectService projectService;
    private final RepositoryMergeConfigDao repositoryMergeConfigDao;
    private final RepositoryService repositoryService;
    private final ScmMergeConfigDao scmMergeConfigDao;
    private final SecurityService securityService;
    private final PlatformTransactionManager transactionManager;
    private Environment environment;

    @Autowired
    public MigrateMergeConfigUpgradeTask(ConfigurationService configurationService, HomeLayout homeLayout, LockService lockService, ProjectMergeConfigDao projectMergeConfigDao, ProjectService projectService, RepositoryMergeConfigDao repositoryMergeConfigDao, RepositoryService repositoryService, ScmMergeConfigDao scmMergeConfigDao, SecurityService securityService, PlatformTransactionManager transactionManager) {
        this.configurationService = configurationService;
        this.homeLayout = homeLayout;
        this.lockService = lockService;
        this.projectMergeConfigDao = projectMergeConfigDao;
        this.projectService = projectService;
        this.repositoryMergeConfigDao = repositoryMergeConfigDao;
        this.repositoryService = repositoryService;
        this.scmMergeConfigDao = scmMergeConfigDao;
        this.securityService = securityService;
        this.transactionManager = transactionManager;
    }

    @PostConstruct
    public void apply() throws Exception {
        Path markerFile = this.homeLayout.getUpgradesDir().resolve(KEY_TASK);
        if (Files.exists(markerFile, new LinkOption[0])) {
            log.debug("Skipping upgrade task to migrate the merge strategies as this has already been completed");
            return;
        }
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(KEY_TASK_LOCK));){
            log.debug("Locked upgrade task {}", (Object)KEY_TASK_LOCK);
            if (Files.exists(markerFile, new LinkOption[0])) {
                log.debug("Skipping upgrade task to migrate the merge strategies as this has already been completed");
                return;
            }
            int completedCount = (Integer)this.securityService.withPermission(Permission.PROJECT_READ, "Migrating merge strategies").call(this::upgrade);
            if (completedCount > 0) {
                log.info("Successfully migrated {} merge strategies from the config to the database", (Object)completedCount);
            }
            MoreFiles.mkdir((Path)markerFile.getParent());
            MoreFiles.touch((Path)markerFile);
        }
        log.debug("Released upgrade task lock {}", (Object)KEY_TASK_LOCK);
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int upgrade() {
        EnumerablePropertySource<?> propertySource = this.findPropertySource();
        if (propertySource == null) {
            return 0;
        }
        TransactionBatcher batch = new TransactionBatcher(this.transactionManager, 50, this.getClass().getSimpleName());
        DeprecateConfigurationRequest.Builder removeBuilder = new DeprecateConfigurationRequest.Builder(DEPRECATION_MESSAGE);
        try {
            batch.start();
            Stream.of(propertySource.getPropertyNames()).filter(propertyName -> propertyName.startsWith(MERGE_STRATEGY_KEY)).filter(propertyName -> this.migrateProperty(batch, (String)propertyName, String.valueOf(propertySource.getProperty(propertyName)))).forEach(arg_0 -> ((DeprecateConfigurationRequest.Builder)removeBuilder).property(arg_0));
            batch.commit();
        }
        finally {
            if (batch.rollback()) {
                log.warn("Rolled back {} partially-migrated merge strategies", (Object)batch.getUncommittedCount());
            }
        }
        DeprecateConfigurationRequest request = removeBuilder.build();
        if (!request.getProperties().isEmpty()) {
            this.configurationService.removeMergeStrategyProperties(request);
        }
        return batch.getCount();
    }

    @Nullable
    private static String normalizeStrategyId(@Nonnull String value) {
        String strategyId = value.toLowerCase(Locale.ROOT).replace('_', '-');
        return VALID_STRATEGY_IDS.contains(strategyId) ? strategyId : null;
    }

    @Nullable
    private EnumerablePropertySource<?> findPropertySource() {
        return (EnumerablePropertySource)PropertySourceUtils.getPropertySource((Environment)this.environment, (Path)this.homeLayout.getSharedHomeDir().resolve("bitbucket.properties"));
    }

    private boolean migrateProperty(TransactionBatcher batch, String propertyName, String propertyValue) {
        String configLevel = propertyName.substring(MERGE_STRATEGY_KEY.length());
        String[] keyAndSlug = StringUtils.split((String)configLevel, (char)'.');
        if (keyAndSlug.length > 2) {
            log.warn("Ignoring incorrectly formatted merge strategy: {}={}", (Object)propertyName, (Object)propertyValue);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            log.warn("Ignoring {}; no strategy was defined", (Object)propertyName);
            return true;
        }
        String strategyId = MigrateMergeConfigUpgradeTask.normalizeStrategyId(propertyValue);
        if (strategyId == null) {
            log.warn("Ignoring {}; {} is not a valid strategy", (Object)propertyName, (Object)propertyValue);
            return true;
        }
        try {
            if (keyAndSlug.length == 0) {
                this.scmMergeConfigDao.create((Object)new InternalScmMergeConfig(SCM_ID, 20, strategyId, Collections.singleton(strategyId)));
                batch.tick();
            } else if (keyAndSlug.length == 1) {
                Project project = this.projectService.getByKey(keyAndSlug[0]);
                if (project == null) {
                    log.warn("Project {} does not exist; strategy {} will not be migrated", (Object)keyAndSlug[0], (Object)strategyId);
                } else {
                    this.projectMergeConfigDao.create((Object)new InternalProjectMergeConfig(InternalConverter.convertToInternalProject((Project)project), SCM_ID, 20, strategyId, Collections.singleton(strategyId), null));
                    batch.tick();
                }
            } else {
                Repository repo = this.repositoryService.getBySlug(keyAndSlug[0], keyAndSlug[1]);
                if (repo == null) {
                    log.warn("Repository {}/{} does not exist; strategy {} will not be migrated", new Object[]{keyAndSlug[0], keyAndSlug[1], strategyId});
                } else {
                    this.repositoryMergeConfigDao.create((Object)new InternalRepositoryMergeConfig(InternalConverter.convertToInternalRepository((Repository)repo), 20, strategyId, Collections.singleton(strategyId), null));
                    batch.tick();
                }
            }
        }
        catch (RuntimeException e) {
            log.warn("{}={} could not be migrated", new Object[]{propertyName, strategyId, e});
        }
        return true;
    }
}

