/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.stash.internal.mesh.ReplicaRequirement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailabilityZoneRequirement
implements ReplicaRequirement {
    private static final Logger log = LoggerFactory.getLogger(AvailabilityZoneRequirement.class);
    private final Map<String, Map<Integer, Set<ReplicaRequirement.VirtualReplica>>> replicasByAzAndPartition;

    public AvailabilityZoneRequirement(List<MeshPartitionReplica> allReplicas) {
        this.replicasByAzAndPartition = allReplicas.stream().map(ReplicaRequirement.VirtualReplica::of).filter(replica -> replica.node().getAvailabilityZone() != null).collect(Collectors.groupingBy(r -> r.node().getAvailabilityZone(), Collectors.groupingBy(ReplicaRequirement.VirtualReplica::partition, Collectors.toSet())));
    }

    @Override
    public void move(@Nonnull MeshPartitionReplica replica, @Nullable MeshNode source, @Nonnull MeshNode target) {
        Objects.requireNonNull(replica, "replica");
        Objects.requireNonNull(target, "target");
        String sourceAz = source != null ? source.getAvailabilityZone() : null;
        String targetAz = target.getAvailabilityZone();
        ReplicaRequirement.VirtualReplica virtualReplica = ReplicaRequirement.VirtualReplica.of(replica);
        if (!Objects.equals(sourceAz, targetAz)) {
            log.trace("Moving partition {} from {} to {}", new Object[]{replica.getPartition(), sourceAz, targetAz});
            if (sourceAz != null) {
                this.replicasByAzAndPartition.get(sourceAz).getOrDefault(virtualReplica.partition(), Collections.emptySet()).remove(virtualReplica);
            }
            if (targetAz != null) {
                this.replicasByAzAndPartition.computeIfAbsent(targetAz, ignored -> new HashMap()).computeIfAbsent(virtualReplica.partition(), ignored -> new HashSet()).add(virtualReplica);
            }
        }
    }

    @Override
    public boolean test(@Nullable MeshPartitionReplica existing, @Nonnull MeshNode meshNode, int partition) {
        ReplicaRequirement.VirtualReplica virtualReplica;
        Objects.requireNonNull(meshNode, "meshNode");
        if (!meshNode.hasAvailabilityZone()) {
            return true;
        }
        Map<Integer, Set<ReplicaRequirement.VirtualReplica>> replicasByPartitionInAz = this.replicasByAzAndPartition.get(meshNode.getAvailabilityZone());
        if (replicasByPartitionInAz == null || replicasByPartitionInAz.isEmpty()) {
            return true;
        }
        Set<ReplicaRequirement.VirtualReplica> replicasOfPartitionInAz = replicasByPartitionInAz.get(partition);
        if (replicasOfPartitionInAz == null) {
            return true;
        }
        ReplicaRequirement.VirtualReplica virtualReplica2 = virtualReplica = existing == null ? null : ReplicaRequirement.VirtualReplica.of(existing);
        if (virtualReplica != null && replicasOfPartitionInAz.size() == 1 && replicasOfPartitionInAz.contains(virtualReplica)) {
            return true;
        }
        return replicasOfPartitionInAz.isEmpty();
    }
}

