/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.stash.internal.mesh.ReplicaRequirement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancedDistributionRequirement
implements ReplicaRequirement {
    private static final Logger log = LoggerFactory.getLogger(BalancedDistributionRequirement.class);
    private final float distributionFactor;
    private final Map<Long, Integer> numberOfReplicasByNode;
    private int fewestPartitionsOnAnyNode;

    public BalancedDistributionRequirement(Map<MeshNode, Set<MeshPartitionReplica>> replicasByNode, float distributionFactor) {
        this.numberOfReplicasByNode = replicasByNode.entrySet().stream().map(entry -> Map.entry(((MeshNode)entry.getKey()).getId(), ((Set)entry.getValue()).size())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.distributionFactor = distributionFactor;
        this.fewestPartitionsOnAnyNode = this.computeFewestPartitionsOnAnyNode();
    }

    @Override
    public void move(@Nonnull MeshPartitionReplica replica, @Nullable MeshNode source, @Nonnull MeshNode target) {
        Objects.requireNonNull(replica, "replica");
        Objects.requireNonNull(target, "target");
        if (Objects.equals(source, target)) {
            return;
        }
        log.trace("Moving partition {} from {} to {}", new Object[]{replica.getPartition(), source, target});
        this.numberOfReplicasByNode.compute(target.getId(), (ignored, count) -> count == null ? 1 : count + 1);
        if (source != null) {
            this.numberOfReplicasByNode.compute(source.getId(), (ignored, count) -> count == null ? 0 : count - 1);
        }
        this.fewestPartitionsOnAnyNode = this.computeFewestPartitionsOnAnyNode();
    }

    @Override
    public boolean test(@Nullable MeshPartitionReplica ignored, @Nonnull MeshNode meshNode, int partition) {
        Objects.requireNonNull(meshNode, "meshNode");
        Integer numberOfReplicasOnNode = this.numberOfReplicasByNode.get(meshNode.getId());
        return numberOfReplicasOnNode == null || this.fewestPartitionsOnAnyNode == Integer.MAX_VALUE || (float)numberOfReplicasOnNode.intValue() <= this.distributionFactor * (float)this.fewestPartitionsOnAnyNode;
    }

    private int computeFewestPartitionsOnAnyNode() {
        int fewestPartitions = this.numberOfReplicasByNode.values().stream().min(Comparator.naturalOrder()).orElse(Integer.MAX_VALUE);
        if (fewestPartitions == 0) {
            return Integer.MAX_VALUE;
        }
        return fewestPartitions;
    }
}

