/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.AssignPartitionRequest;
import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.mesh.PartitionAssignmentStrategy;
import com.atlassian.stash.internal.repository.RepositoryDao;
import jakarta.annotation.Nonnull;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="balanced")
public class BalancedPartitionAssignmentStrategy
implements PartitionAssignmentStrategy {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final Logger log = LoggerFactory.getLogger(BalancedPartitionAssignmentStrategy.class);
    private final InternalMeshPartitionRegistry partitionRegistry;
    private final RepositoryDao repositoryDao;

    @Autowired
    public BalancedPartitionAssignmentStrategy(RepositoryDao repositoryDao, InternalMeshPartitionRegistry partitionRegistry) {
        this.repositoryDao = repositoryDao;
        this.partitionRegistry = partitionRegistry;
    }

    @Override
    public int assign(@Nonnull AssignPartitionRequest request) {
        Set availablePartitions = (Set)this.partitionRegistry.getAllPartitions().stream().filter(MeshPartition::isAvailable).map(MeshPartition::getId).collect(MoreCollectors.toImmutableSet());
        if (availablePartitions.isEmpty()) {
            log.warn("Cannot assign hierarchy {} to a partition; all nodes are offline", (Object)request.getHierarchyId());
            return -1;
        }
        Map counts = this.repositoryDao.countAllByPartition();
        Map.Entry leastPopulatedPartitions = availablePartitions.stream().map(partition -> Pair.of((Object)partition, (Object)counts.getOrDefault(partition, 0L))).collect(Collectors.collectingAndThen(Collectors.groupingBy(Pair::getValue, TreeMap::new, Collectors.mapping(Pair::getKey, MoreCollectors.toImmutableSet())), TreeMap::firstEntry));
        Set partitionCandidates = leastPopulatedPartitions == null ? availablePartitions : (Set)leastPopulatedPartitions.getValue();
        return (Integer)new ArrayList(partitionCandidates).get(RANDOM.nextInt(partitionCandidates.size()));
    }
}

