/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigration;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;

class ConfigVersion
implements Serializable {
    public static final String NULL_HASH = ConfigVersion.newHasher().hash().toString();
    private static final long serialVersionUID = 3544723030855729200L;
    private final String configHash;
    private final String nodeHash;
    private final String nodeListHash;
    private final String topologyHash;
    private final String topologySliceHash;
    private int failedCount;

    ConfigVersion() {
        this(NULL_HASH, NULL_HASH, NULL_HASH, NULL_HASH, NULL_HASH);
    }

    ConfigVersion(@Nonnull String nodeHash, @Nonnull String nodeListHash, @Nonnull String configHash, @Nonnull String topologyHash, @Nonnull String topologySliceHash) {
        this.configHash = Objects.requireNonNull(configHash, "configHash");
        this.nodeHash = Objects.requireNonNull(nodeHash, "nodeHash");
        this.nodeListHash = Objects.requireNonNull(nodeListHash, "nodeListHash");
        this.topologyHash = Objects.requireNonNull(topologyHash, "topologyHash");
        this.topologySliceHash = Objects.requireNonNull(topologySliceHash, "topologySliceHash");
    }

    @Nonnull
    public static String nodeHash(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        return ConfigVersion.newHasher().putLong(node.getId()).putByte((byte)0).putString((CharSequence)node.getRpcUrl(), StandardCharsets.UTF_8).putByte((byte)0).putString((CharSequence)node.getName(), StandardCharsets.UTF_8).putByte((byte)0).hash().toString();
    }

    @Nonnull
    public static String nodeListHash(Collection<MeshPartition> partitions) {
        Hasher hasher = ConfigVersion.newHasher();
        partitions.stream().flatMap(partition -> partition.getReplicas().stream()).map(MeshPartitionReplica::getNode).distinct().sorted(Comparator.comparingLong(MeshNode::getId)).forEach(node -> hasher.putLong(node.getId()).putByte((byte)0).putString((CharSequence)node.getRpcUrl(), StandardCharsets.UTF_8).putByte((byte)0).putString((CharSequence)node.getName(), StandardCharsets.UTF_8).putByte((byte)0));
        return hasher.hash().toString();
    }

    @Nonnull
    public static String topologyHash(@Nonnull Iterable<MeshPartition> partitions, @Nonnull Iterable<MeshPartitionMigration> migrations) {
        Objects.requireNonNull(partitions, "partitions");
        Objects.requireNonNull(migrations, "migrations");
        return ConfigVersion.topologyHash(partitions, migrations, ignored -> true);
    }

    @Nonnull
    public static String topologySliceHash(@Nonnull MeshNode node, @Nonnull Iterable<MeshPartition> partitions) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(partitions, "partitions");
        return ConfigVersion.topologyHash(partitions, Collections.emptyList(), partition -> partition.getReplicas().stream().anyMatch(replica -> replica.getNode().equals((Object)node)));
    }

    @Nonnull
    public String getConfigHash() {
        return this.configHash;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    @Nonnull
    public String getNodeHash() {
        return this.nodeHash;
    }

    @Nonnull
    public String getNodeListHash() {
        return this.nodeListHash;
    }

    @Nonnull
    public String getTopologyHash() {
        return this.topologyHash;
    }

    @Nonnull
    public String getTopologySliceHash() {
        return this.topologySliceHash;
    }

    public int incrementFailedCount() {
        return ++this.failedCount;
    }

    private static Hasher newHasher() {
        return Hashing.sha256().newHasher();
    }

    private static String topologyHash(Iterable<MeshPartition> partitions, Iterable<MeshPartitionMigration> migrations, Predicate<MeshPartition> filter) {
        Hasher hasher = ConfigVersion.newHasher();
        for (MeshPartition partition : partitions) {
            if (!filter.test(partition)) continue;
            hasher.putInt(partition.getId());
            for (MeshPartitionReplica replica : partition.getReplicas()) {
                hasher.putLong(replica.getId());
                MeshNode node = replica.getNode();
                hasher.putLong(node.getId());
                hasher.putString((CharSequence)node.getRpcUrl(), StandardCharsets.UTF_8);
            }
            hasher.putByte((byte)0);
        }
        for (MeshPartitionMigration migration : migrations) {
            hasher.putInt(migration.getPartition());
            hasher.putLong(migration.getSourceNode().getId());
            hasher.putLong(migration.getTargetNode().getId());
            hasher.putByte((byte)0);
        }
        return hasher.hash().toString();
    }
}

