/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.InconsistentRepositoryReplica;
import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigration;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.NoSuchMeshNodeException;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInconsistentReplica;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPartition;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPartitionReplica;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPartitionReplicaMigration;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublicKey;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublicKeyConfiguration;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublicKeyList;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetConfigurationRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTopology;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.nutcluster.map.EntryBackupProcessor;
import com.atlassian.nutcluster.map.EntryProcessor;
import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.stash.internal.mesh.ConfigVersion;
import com.atlassian.stash.internal.mesh.ControlPlaneState;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionMigrationService;
import com.atlassian.stash.internal.mesh.MeshConfig;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.mesh.MeshNodeConfigurer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import io.atlassian.fugue.retry.RetryFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.PersistenceException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@SpringAware
class ConfigureMeshTask
implements EntryProcessor<String, ControlPlaneState> {
    private static final Logger log = LoggerFactory.getLogger(ConfigureMeshTask.class);
    private static final long serialVersionUID = 5747635171566446364L;
    private final MeshConfig config;
    private final boolean refreshTopology;
    private transient BackupProcessor backupProcessor;
    private boolean forceTopologyUpdate;
    private transient MeshKeyManager keyManager;
    private transient RpcManagementClient managementClient;
    private transient MeshNodeConfigurer meshNodeConfigurer;
    private transient DmzMeshService meshService;
    private Set<Long> nodesToClear;
    private transient InternalMeshPartitionMigrationService partitionMigrationService;
    private transient DmzMeshPartitionRegistry partitionRegistry;
    private transient EscalatedSecurityContext withSysAdmin;

    private ConfigureMeshTask(@Nullable MeshConfig config, boolean refreshTopology) {
        this.config = config;
        this.refreshTopology = refreshTopology;
    }

    public static RpcPublicKey toPublicKey(PublicKey publicKey) {
        return RpcPublicKey.newBuilder().setDer(ByteString.copyFrom((byte[])publicKey.getEncoded())).build();
    }

    public EntryBackupProcessor<String, ControlPlaneState> getBackupProcessor() {
        return this.backupProcessor;
    }

    public String process(Map.Entry<String, ControlPlaneState> entry) {
        return (String)RetryFactory.create(() -> this.internalProcess(entry), (int)3, e -> {
            if (e instanceof PersistenceException) {
                log.info("Retrying ConfigureMeshTask after " + e.getClass().getSimpleName() + " occurrred.", (Throwable)(log.isDebugEnabled() ? e : null));
                return;
            }
            throw e;
        }, (long)50L).get();
    }

    @Autowired
    public void setManagementClient(RpcManagementClient managementClient) {
        this.managementClient = managementClient;
    }

    @Autowired
    public void setMeshKeyManager(MeshKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    @Autowired
    public void setMeshNodeConfigurer(MeshNodeConfigurer meshNodeConfigurer) {
        this.meshNodeConfigurer = meshNodeConfigurer;
    }

    @Autowired
    public void setMeshPartitionMigrationService(InternalMeshPartitionMigrationService partitionMigrationService) {
        this.partitionMigrationService = partitionMigrationService;
    }

    @Autowired
    public void setMeshService(DmzMeshService meshService) {
        this.meshService = meshService;
    }

    @Autowired
    public void setPartitionRegistry(DmzMeshPartitionRegistry partitionRegistry) {
        this.partitionRegistry = partitionRegistry;
    }

    @Autowired
    public void setSecurityService(SecurityService securityService) {
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "ConfigureMeshTask");
    }

    @Nonnull
    static ConfigureMeshTask forConfigUpdate(@Nonnull MeshConfig config) {
        return new ConfigureMeshTask(Objects.requireNonNull(config, "config"), false);
    }

    @Nonnull
    static ConfigureMeshTask forForcedTopologyUpdate() {
        ConfigureMeshTask task = new ConfigureMeshTask(null, true);
        task.forceTopologyUpdate();
        return task;
    }

    @Nonnull
    static ConfigureMeshTask forForcedUpdate(long nodeId) {
        ConfigureMeshTask task = new ConfigureMeshTask(null, false);
        task.forceConfiguration(nodeId);
        return task;
    }

    @Nonnull
    static ConfigureMeshTask forTopologyUpdate() {
        return new ConfigureMeshTask(null, true);
    }

    @Nonnull
    static ConfigureMeshTask forUpToDateCheck() {
        return new ConfigureMeshTask(null, false);
    }

    @VisibleForTesting
    MeshConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    Set<Long> getNodesToClear() {
        return this.nodesToClear;
    }

    @VisibleForTesting
    boolean isRefreshTopology() {
        return this.refreshTopology;
    }

    private static Map<Long, Pair<List<MeshPartition>, List<MeshPartitionMigration>>> getTopologiesForNodes(Iterable<MeshNode> nodes, ControlPlaneState state, Collection<MeshPartition> partitions, Collection<MeshPartitionMigration> migrations, boolean allNodes) {
        Map migrationsByPartition = migrations.stream().collect(Collectors.groupingBy(MeshPartitionMigration::getPartition, MoreCollectors.toImmutableList()));
        HashMap<Long, Pair<List<MeshPartition>, List<MeshPartitionMigration>>> result = new HashMap<Long, Pair<List<MeshPartition>, List<MeshPartitionMigration>>>();
        for (MeshNode node : nodes) {
            if (!allNodes && state.hasCurrentTopology(node)) continue;
            result.put(node.getId(), (Pair<List<MeshPartition>, List<MeshPartitionMigration>>)Pair.of(new ArrayList(), new ArrayList()));
        }
        if (result.isEmpty()) {
            return result;
        }
        for (MeshPartition partition : partitions) {
            for (MeshPartitionReplica replica : partition.getReplicas()) {
                result.computeIfPresent(replica.getNode().getId(), (id, slice) -> {
                    ((List)slice.getLeft()).add(partition);
                    List migrationsForPartition = (List)migrationsByPartition.get(partition.getId());
                    if (migrationsForPartition != null) {
                        ((List)slice.getRight()).addAll(migrationsForPartition);
                    }
                    return slice;
                });
            }
        }
        return result;
    }

    private static RpcInconsistentReplica toInconsistentReplica(InconsistentRepositoryReplica inconsistentReplica) {
        return RpcInconsistentReplica.newBuilder().setRepository(inconsistentReplica.getRepositoryId().toString()).setVersion(inconsistentReplica.getVersion()).build();
    }

    private static RpcNode toNode(MeshNode node) {
        return RpcNode.newBuilder().setAvailabilityZone(StringUtils.defaultString((String)node.getAvailabilityZone())).setId(node.getRpcId()).setName(StringUtils.defaultString((String)node.getName())).setRpcUrl(node.getRpcUrl()).build();
    }

    private static RpcPartitionReplica toPartitionReplica(MeshPartitionReplica replica) {
        return RpcPartitionReplica.newBuilder().setId(Long.toString(replica.getId())).setNodeId(replica.getNode().getRpcId()).build();
    }

    private static RpcPartitionReplicaMigration toPartitionReplicaMigration(MeshPartitionMigration migration) {
        return RpcPartitionReplicaMigration.newBuilder().setPartition(RemoteRepositoryId.getPartitionHex((int)migration.getPartition())).setSourceNodeId(migration.getSourceNode().getRpcId()).setTargetNodeId(migration.getTargetNode().getRpcId()).build();
    }

    private Map<Long, TopologySlice> buildTopologies(Iterable<MeshNode> nodes, ControlPlaneState state, Collection<MeshPartition> partitions, Collection<MeshPartitionMigration> migrations) {
        Map<Long, Pair<List<MeshPartition>, List<MeshPartitionMigration>>> slices = ConfigureMeshTask.getTopologiesForNodes(nodes, state, partitions, migrations, this.forceTopologyUpdate);
        if (slices.isEmpty()) {
            return Collections.emptyMap();
        }
        Map sliceHashes = Maps.transformValues(slices, input -> ConfigVersion.topologyHash((Iterable)input.getLeft(), (Iterable)input.getRight()));
        if (!this.forceTopologyUpdate) {
            slices.keySet().removeIf(nodeId -> state.getTopologySliceHash((long)nodeId).equals(sliceHashes.get(nodeId)));
        }
        HashMap keyCache = new HashMap();
        HashMap nodeCache = new HashMap();
        HashMap partitionCache = new HashMap();
        return slices.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            RpcTopology.Builder builder = RpcTopology.newBuilder();
            HashSet connectedNodes = new HashSet();
            for (MeshPartition partition : (List)((Pair)entry.getValue()).getLeft()) {
                builder.addPartitions(partitionCache.computeIfAbsent(partition.getId(), id -> RpcPartition.newBuilder().addAllReplicas((Iterable)Lists.transform((List)partition.getReplicas(), ConfigureMeshTask::toPartitionReplica)).setId(RemoteRepositoryId.getPartitionHex((int)id)).build()));
                partition.getReplicas().stream().map(MeshPartitionReplica::getNode).forEach(connectedNodes::add);
            }
            long localId = (Long)entry.getKey();
            HashMap<String, RpcPublicKeyList> keysByNode = new HashMap<String, RpcPublicKeyList>();
            for (MeshNode node : connectedNodes) {
                RpcPublicKeyList keyList;
                long nodeId = node.getId();
                builder.addNodes(nodeCache.computeIfAbsent(nodeId, id -> ConfigureMeshTask.toNode(node)));
                if (nodeId == localId || (keyList = keyCache.computeIfAbsent(nodeId, id -> this.getPublicKeys(node))).getPublicKeysCount() <= 0) continue;
                keysByNode.put(node.getRpcId(), keyList);
            }
            for (MeshPartitionMigration meshPartitionMigration : (List)((Pair)entry.getValue()).getRight()) {
                builder.addPartitionMigrations(ConfigureMeshTask.toPartitionReplicaMigration(meshPartitionMigration));
            }
            return new TopologySlice((String)sliceHashes.get(entry.getKey()), keysByNode, builder.build());
        }));
    }

    private void forceConfiguration(long nodeId) {
        if (this.nodesToClear == null) {
            this.nodesToClear = new HashSet<Long>();
        }
        this.nodesToClear.add(nodeId);
    }

    private void forceTopologyUpdate() {
        this.forceTopologyUpdate = true;
    }

    private Iterable<RpcInconsistentReplica> getInconsistentReplicas(MeshNode node) {
        return Iterables.transform((Iterable)this.partitionRegistry.getInconsistentRepositoryReplicas(node), ConfigureMeshTask::toInconsistentReplica);
    }

    private RpcPublicKeyList getPublicKeys(MeshNode node) {
        List keys = this.keyManager.getKeysByNode(node);
        return keys.isEmpty() ? RpcPublicKeyList.getDefaultInstance() : RpcPublicKeyList.newBuilder().addAllPublicKeys(Iterables.transform((Iterable)keys, ConfigureMeshTask::toPublicKey)).build();
    }

    private String internalProcess(Map.Entry<String, ControlPlaneState> entry) {
        List migrations;
        Collection partitions;
        boolean changed = false;
        ControlPlaneState state = entry.getValue();
        if (state == null) {
            state = new ControlPlaneState();
            changed = true;
        }
        if (this.config != null) {
            MeshConfig updated = this.config.isUpdate() ? state.getConfig().merge(this.config) : this.config;
            boolean bl = changed = state.setConfig(updated) || changed;
        }
        if (this.refreshTopology) {
            this.partitionRegistry.refresh();
        }
        changed = state.setTopologyHash(ConfigVersion.topologyHash(partitions = this.partitionRegistry.getAllPartitions(), migrations = this.partitionMigrationService.getAllForTopologyUpdate())) || changed;
        boolean bl = changed = state.setNodeListHash(ConfigVersion.nodeListHash(partitions)) || changed;
        if (this.nodesToClear != null && !this.nodesToClear.isEmpty()) {
            this.nodesToClear.forEach(state::clearNodeState);
            changed = true;
        }
        boolean bl2 = changed = this.maybeConfigureNodes(state, partitions, migrations) || changed;
        if (changed) {
            entry.setValue(state);
            this.backupProcessor = new BackupProcessor(state);
        }
        return state.getConfig().getHash();
    }

    private boolean maybeConfigureNodes(ControlPlaneState state, Collection<MeshPartition> partitions, Collection<MeshPartitionMigration> migrations) {
        boolean changed = false;
        List nodes = (List)this.withSysAdmin.call(() -> ((DmzMeshService)this.meshService).getMembers());
        RpcPublicKeyList sidecarKeys = RpcPublicKeyList.newBuilder().addPublicKeys(ConfigureMeshTask.toPublicKey(this.keyManager.getSidecarKeys().getPublic())).build();
        Map<Long, TopologySlice> topologies = this.buildTopologies(nodes, state, partitions, migrations);
        for (MeshNode node : nodes) {
            if (node.isSidecar()) continue;
            boolean needsConfig = !state.hasCurrentConfig(node);
            boolean needsNodeDetails = !state.hasCurrentNodeDetails(node);
            boolean needsTopology = topologies.containsKey(node.getId());
            String topologySliceHash = state.getTopologySliceHash(node.getId());
            if (!needsConfig && !needsNodeDetails && !needsTopology) continue;
            RpcSetConfigurationRequest.Builder builder = RpcSetConfigurationRequest.newBuilder().addAllInconsistentReplicas(this.getInconsistentReplicas(node));
            if (needsConfig || needsNodeDetails) {
                MeshConfig config = needsConfig ? state.getConfig() : null;
                builder.setNodeConfiguration(this.meshNodeConfigurer.buildNodeConfiguration(config, node));
            }
            if (needsTopology) {
                TopologySlice slice = topologies.get(node.getId());
                builder.setPublicKeyConfiguration(RpcPublicKeyConfiguration.newBuilder().putAllNodePublicKeys(slice.getKeysByNode()).setComplete(true).setSidecarKeys(sidecarKeys)).setTopology(slice.getTopology());
                topologySliceHash = slice.getHash();
            }
            try {
                this.managementClient.updateConfig(node, builder.build());
                state.markUpToDate(node, topologySliceHash);
                changed = true;
            }
            catch (RepositoryOfflineException e) {
                log.debug("Could not configure node {}; it is offline", (Object)node);
            }
            catch (NoSuchMeshNodeException e) {
                log.debug("Could not configure node {}; it has been deleted", (Object)node);
            }
            catch (RuntimeException e) {
                int failedCount = state.markFailed(node);
                log.warn("Failed to configure node {} (failures = {}, config = {}, node = {}, topology = {})", new Object[]{node, failedCount, needsConfig, needsNodeDetails, needsTopology, e});
                changed = true;
            }
        }
        return changed;
    }

    public static class BackupProcessor
    implements EntryBackupProcessor<String, ControlPlaneState> {
        private static final long serialVersionUID = 272807005938837691L;
        private final ControlPlaneState state;

        BackupProcessor(ControlPlaneState state) {
            this.state = state;
        }

        public void processBackup(Map.Entry<String, ControlPlaneState> entry) {
            entry.setValue(this.state);
        }
    }

    private static class TopologySlice {
        private final String hash;
        private final Map<String, RpcPublicKeyList> keysByNode;
        private final RpcTopology topology;

        TopologySlice(String hash, Map<String, RpcPublicKeyList> keysByNode, RpcTopology topology) {
            this.hash = hash;
            this.keysByNode = keysByNode;
            this.topology = topology;
        }

        String getHash() {
            return this.hash;
        }

        Map<String, RpcPublicKeyList> getKeysByNode() {
            return this.keysByNode;
        }

        RpcTopology getTopology() {
            return this.topology;
        }
    }
}

